#ifndef KP_WORKOUT_H_
#define KP_WORKOUT_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "kpcalendarentry.h"

#define KP_TYPE_WORKOUT (kp_workout_get_type())
#define KP_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_WORKOUT, KPWorkout))
#define KP_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_WORKOUT, KPWorkoutClass))
#define KP_IS_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_WORKOUT))
#define KP_IS_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_WORKOUT))
#define KP_WORKOUT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_WORKOUT, KPWorkoutClass))

typedef struct KPWorkout_
{
  KPCalendarEntry   parent_instance;

  GString          *sport;
  
  GSList           *splits;  
  GHashTable       *params;
}
KPWorkout;

typedef struct KPWorkoutClass_ {
  KPCalendarEntryClass parent_class;  
} KPWorkoutClass;

typedef enum {
  KP_WORKOUT_SPLIT_TYPE_NORMAL,
  KP_WORKOUT_SPLIT_TYPE_WARM_UP,
  KP_WORKOUT_SPLIT_TYPE_COOL_DOWN,
  KP_WORKOUT_SPLIT_TYPE_RECOVERY,
  KP_WORKOUT_SPLIT_TYPE_N
} KPWorkoutSplitType;

typedef struct KPWorkoutSplit_ {
  KPWorkoutSplitType  type;  
  guint               n;
  
  gdouble             distance;
  KPCalendarTime     *time;
  
  gchar              *comment;
} KPWorkoutSplit;


GType         kp_workout_get_type                     (void);
 
KPWorkout    *kp_workout_new                          (void);
void          kp_workout_destroy                      (KPWorkout *wo);
gint          kp_workout_cmp                          (gconstpointer a,
                                                       gconstpointer b);
gboolean      kp_workout_is_valid                     (KPWorkout *wo);
void          kp_workout_add_split                    (KPWorkout *wo,
                                                       KPWorkoutSplitType,
                                                       guint n,
                                                       gfloat distance,
                                                       KPCalendarTime *ct,
                                                       const gchar *comment);
void          kp_workout_set_sport                    (KPWorkout *wo,
                                                       const gchar *sport);
gchar        *kp_workout_get_sport                    (KPWorkout *wo);
guint         kp_workout_get_pace                     (KPWorkout *wo);
guint         kp_workout_get_n_splits                 (KPWorkout *wo);
GSList       *kp_workout_get_splits                   (KPWorkout *wo);
gdouble       kp_workout_get_distance                 (KPWorkout *wo);
gdouble       kp_workout_get_duration_in_seconds      (KPWorkout *wo);
void          kp_workout_set_duration_in_seconds      (KPWorkout *wo,
                                                       gdouble seconds);
guint         kp_workout_get_duration_in_milliseconds (KPWorkout *wo);
void          kp_workout_set_duration_in_milliseconds (KPWorkout *wo,
                                                       guint32 msecs);
gchar        *kp_workout_get_duration_str             (KPWorkout *wo);
gchar        *kp_workout_get_params_string            (KPWorkout *wo);
gint          kp_workout_get_param_int                (KPWorkout *wo,
                                                       const gchar *param);
gdouble       kp_workout_get_param_double             (KPWorkout *wo,
                                                       const gchar *param);
gchar        *kp_workout_get_param                    (KPWorkout *wo,
                                                       const gchar *param);
gchar        *kp_workout_get_formatted_date           (KPWorkout *wo);
gboolean      kp_workout_set_param                    (KPWorkout *wo,
                                                       gboolean replace,
                                                       const gchar *param,
                                                       const GValue *value);
void          kp_workout_print                        (KPWorkout *wo);


#endif
