/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 08:36:08 PDT 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kuniqueapp.h>
#include <kstddirs.h>
#include <kio/netaccess.h>
#include <ktempfile.h>
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>
#include <stdio.h>
#include <stdlib.h>

#include "kfocus.h"

static const char *description =
	I18N_NOOP("Use KFocus to manage and track your personal projects.\n\nVisit http://kfocus.sourceforge.net for more information\nabout the KFocus project.");
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};


int main(int argc, char *argv[])
{

	KAboutData aboutData( "kfocus", I18N_NOOP("KFocus"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, Jeffrey Yu", 0, 0, "jeffyu@cs.stanford.edu");
	aboutData.addAuthor("Jeffrey Yu",0, "jeffyu@cs.stanford.edu");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
/*	
	KUniqueApplication::addCmdLineOptions();
	if (!KUniqueApplication::start()) {
		fprintf(stderr, "kfocus is already running\n");
		exit(0);
	}

  KUniqueApplication app;
 */
  KApplication app;
  if (app.isRestored()) {
    RESTORE(KFocusApp);
  }
  else {
    KFocusApp *kfocus = new KFocusApp();
    kfocus->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count()) {
        kfocus->openDocumentFile(args->url(0));
		}
		else {
			KStandardDirs stddirs;
			QString defaultFile = stddirs.findResource("data", "kfocus/My Focus");
			if (!stddirs.exists(defaultFile)) {
				/* Make a DOM skeleton */
			  QDomDocument dDoc("kfocus");
	
				  QDomElement dElement = dDoc.createElement("kfocus");
  				dElement.setAttribute("version", "1.0");  				
			  	dDoc.appendChild(dElement);
	
				  KTempFile tmpFile;
					(*tmpFile.textStream()) << dDoc.toString() << "\n";
					tmpFile.close();
	
					defaultFile = stddirs.saveLocation("data", "kfocus/") + "My Focus";
					KIO::NetAccess::upload( tmpFile.name(), KURL(defaultFile) );
					tmpFile.unlink();
				}
					
		  kfocus->openDocumentFile(defaultFile);
		}
		args->clear();
  }

  return app.exec();
}  
