#include "misc.h"

#include <qcanvas.h>
#include <qpixmap.h>
#include <qimage.h>

#include <qvariant.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdialog.h>



/**
 TODO: Redesign the getAnimationFromFile.. so it doesn't do automatically the mirrors..
       instead for the mirroring you need to call another function
 
 */

class myDebugDlg : public QDialog
{ 
    Q_OBJECT
public:
    myDebugDlg( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~myDebugDlg();

    QLabel* TextLabel1;
    QListBox* debugListBox;
protected:
    QVBoxLayout* Layout3;
};


bool getAnimationFromFile( QCanvasPixmapArray **images_array ,QString file, 
                           int w, int h, int n_of_animations, 
                           Qt::Orientation orient, int nw, int nh)
{
    int fw = 0, fh = 0;
    bool scaleit = false;
    int real_w, real_h;

    if ( ( n_of_animations < 0 ) ||
         ( w < 0 ) || ( h < 0 ) ||
         ( nw < 0 ) || ( nh < 0 ) )
     return false;
     
    QImage *pic_realimage = new QImage ( file );
    QPixmap *pix_image;

    QImage pic_image;
    QImage pic_scale_image;
    
    QValueList <QPixmap> temp_pix_array;

    if (orient == Qt::Horizontal) fw = 1;
    else fh = 1;
    
    if ( nw == 0 ) real_w = w;
    else { real_w = nw; scaleit = true; }

    if ( nh == 0 ) real_h = h;
    else { real_h = nh; scaleit = true; }
        
    for (int i = 0; i < n_of_animations; i++)
    {
        pic_image. create( real_w, real_h, 16 );
        if (scaleit)
        {
            pic_scale_image. create( fw*w*i, fh*h*i , 16);
            pic_scale_image = pic_realimage -> copy( fw*w*i, fh*h*i, w, h );
            pic_image = pic_scale_image. smoothScale( real_w, real_h, QImage::ScaleFree);
            pic_scale_image. reset();
        }
        else
        {
            pic_image = pic_realimage -> copy( fw*w*i, fh*h*i, w, h );
        }
        pix_image = new QPixmap( pic_image );
        temp_pix_array. append ( *pix_image );        
        pic_image. reset();
    }
    
    QCanvasPixmapArray *pixarray = new QCanvasPixmapArray( temp_pix_array );
    
    *images_array = pixarray;
    delete pic_realimage;
    return true;
}

// the same function as above but specialized to load to the array we need for kfish

bool getKFishAnimation( QCanvasPixmapArray &images_array ,QString file, 
                   int maxw, int maxh)
{
    int fw = 0, fh = 0,w,h;
    
    bool scaleit = false;

    int real_w, real_h;
    QImage *pic_realimage = new QImage ( file );
    w = pic_realimage->width();
    h = pic_realimage->height();
    QPixmap *pix_image;
    QImage pic_image;
    QImage pic_scale_image;
    QValueList <QPixmap> temp_pix_array;

    fw = 1;
    real_h = h;
    real_w = w;
    
    if (real_w>maxw) {
      real_h=((float) maxw / (float) real_w)*real_h;
      real_w=maxw;
      scaleit = true;
    }

    if (real_h>maxh) {
      real_w=((float) maxh/(float) real_h)*real_w;
      real_h=maxh;
      scaleit = true;
    }
    
    //    if ( nw == 0 ) real_w = w;
    //else { real_w = nw; scaleit = true; }

    //if ( nh == 0 ) real_h = h;
    //else { real_h = nh; scaleit = true; }
        
    for (int i = 0; i < 1; i++)
    {
        pic_image. create( real_w, real_h, 16 );
        if (scaleit)
        {
            pic_scale_image. create( fw*w, fh*h, 16);
            pic_scale_image = pic_realimage -> copy( 0, 0, w, h );
            pic_image = pic_scale_image. smoothScale( real_w, real_h, QImage::ScaleFree);
            pic_scale_image. reset();
        }
        else
        {
            pic_image = pic_realimage -> copy( 0, 0, w, h );
        }
        images_array. setImage(i, new QCanvasPixmap( pic_image ) );
        pic_image. reset();
    }
    
    images_array. setImage(1, new QCanvasPixmap( images_array.image(0) -> convertToImage(). mirror(true, false) ));
    delete pic_realimage;
    return true;
}

bool setWall( QString file, QCanvas *canvas )
{
    QPixmap wall( file );
    int cw = canvas -> width() / wall.width();
    if (cw !=0)
        {
            int w = canvas -> width() % wall.width();
            if (w!=0)
                cw++;
        }
    else cw = 1;
    int ch = canvas -> height() / wall.height();
    if (ch != 0)
        {
            int h = canvas -> height() % wall.height();
            if (h != 0)
                ch++;
        }
    else ch = 1;
    
    QPixmap realwall(cw * wall.width(), ch * wall.height());
    for (int rw=0; rw < cw; rw++)
        for (int rh=0; rh < ch; rh++)
        {
            bitBlt(&realwall, rw * wall.width(), rh * wall.height(),
                   &wall, 0, 0, wall.width(), wall.height());
        }
    canvas -> setBackgroundPixmap( realwall );
}


/* DEBUG */


myDebug::myDebug( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{

    setName( "myDebugDlg" );
    resize( 410, 270 ); 
    setBaseSize( QSize( 0, 0 ) );
    setCaption(  "My Applet-Debug window" );

    QWidget* privateLayoutWidget = new QWidget( this, "Layout3" );
    privateLayoutWidget->setGeometry( QRect( 0, 0, 410, 270 ) ); 
    Layout3 = new QVBoxLayout( privateLayoutWidget, 0, 6, "Layout3"); 

    TextLabel1 = new QLabel( privateLayoutWidget, "TextLabel1" );
    QFont TextLabel1_font(  TextLabel1->font() );
    TextLabel1->setFont( TextLabel1_font ); 
    TextLabel1->setText( "Debug... you idiot" );
    Layout3->addWidget( TextLabel1 );

    debugListBox = new QListBox( privateLayoutWidget, "debugListBox" );
    Layout3->addWidget( debugListBox );
    debugListBox -> setAutoScrollBar( true );

    debugListBox -> setAutoBottomScrollBar( true );
//    connect(this, SIGNAL( destroyed() ), SLOT( dlgDelete() ));
    
    show();
}

myDebug::~myDebug()
{
//    delete debugDlg;
}


void myDebug::add(QString text)
{
    debugListBox ->insertItem(text);
}

void myDebug::dlgDelete()
{
//    delete debugDlg;
}
