/***************************************************************************
 *   Copyright (C) 2004 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>
#include <qfileinfo.h>
#include <qdir.h>

#include <ktextedit.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <ktextbrowser.h>
#include <kconfig.h>

#include "KDissertPart.h"
#include "DGenerator.h"
#include "generatorp1.h"
#include "generatorp2.h"
#include "generatorwizard.h"
#include "settings.h"

class KListViewItemGen : public KListViewItem
{
	public:
		KListViewItemGen(KListView* parent, QString s1, DGenerator*gen);
		KListViewItemGen(KListViewItem* parent, QString s1, DGenerator*gen);
		~KListViewItemGen() {}
		DGenerator *m_gen;
};

KListViewItemGen::KListViewItemGen(KListView* parent, QString s1, DGenerator*gen) : 
	KListViewItem(parent, s1)
{
	m_gen = gen;
}

KListViewItemGen::KListViewItemGen(KListViewItem* parent, QString s1, DGenerator*gen) : 
	KListViewItem(parent, s1)
{
	m_gen = gen;
}

generatorwizard::generatorwizard(KDissertPart* part) : KWizard(NULL)
{
	setCaption(i18n("kdissert document generator"));

	m_part = part;
	m_data=NULL;
	m_selected=NULL;

	helpButton()->hide();
	m_page1 = new generatorp1(this);
	addPage(m_page1, i18n("General"));

	m_page2 = new generatorp2(this);
	addPage(m_page2, i18n("Finish"));

	m_page1->doclocation->setMode(KFile::LocalOnly | KFile::Directory);

	KConfig *cfg = new KConfig("kdissertpartrc");
	QString dirstart = cfg->readPathEntry( "dirstart", "/" );
	delete cfg;

	m_page1->doclocation->setURL( dirstart );

	connect(m_page1->docname, SIGNAL(textChanged(const QString &)), this, SLOT(updatelocationlabel()));
	connect(m_page1->doclocation, SIGNAL(textChanged(const QString &)), this, SLOT(updatelocationlabel()));
	connect(m_page1->doclocation, SIGNAL(urlSelected(const QString &)), this, SLOT(updatelocationlabel()));
	connect(m_page1->templatelist, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(updateselectedtemplate(QListViewItem*)) );
	connect(m_page1->templatelist, SIGNAL(selectionChanged()), this, SLOT(updatelocationlabel()) );

	updatelocationlabel();

	connect(this, SIGNAL(selected(const QString&)), this, SLOT(checksteps()) );

	setNextEnabled( m_page1, false );
	setNextEnabled( m_page2, false );
	setFinishEnabled( m_page2, false );
	setFinishEnabled( m_page2, false );
}


generatorwizard::~generatorwizard()
{
}

void generatorwizard::accept()
{
	if ( ! isvalidlocation()) 
	{
		KMessageBox::sorry(this, i18n("The directory you have chosen as the location for "
					"the project already exists."));
		showPage(m_page1);
		m_page1->docname->setFocus();
		checksteps();
		return;
	}

	if ( ! m_selected )
	{
		KMessageBox::sorry(this, i18n("Something really wrong happened : "
					"a pointer became suddenly NULL :-/") );
		checksteps();
		m_page1->docname->setFocus();
		showPage(m_page1);
		return;
	}

	KConfig *cfg = new KConfig("kdissertpartrc");
	cfg->writePathEntry( "dirstart", m_page1->doclocation->url() );
	delete cfg;

	connect(m_selected, SIGNAL(documentGenerated(const QString&, bool)), m_part, SLOT(launchURL(const QString&, bool)) );
	m_selected->generate(m_page1->docfinallocation->text(), m_data);
	disconnect(m_selected, SIGNAL(documentGenerated(const QString&, bool)), m_part, SLOT(launchURL(const QString&, bool)) );

	KWizard::accept();
}

bool generatorwizard::isvalidlocation()
{
	m_page1->validlabel->setText(QString::null);

	if (m_page1->docname->text().length() < 1)
	{
		m_page1->validlabel->setText( i18n("(invalid : please specify a folder)") );
		return false;
	}
	QFileInfo fi(m_page1->doclocation->url());
	if (!fi.isDir())
	{
		m_page1->validlabel->setText( i18n("(invalid folder)") );
		return false;
	}
	if (!fi.isWritable())
	{
		m_page1->validlabel->setText( i18n("(invalid : folder is locked)") );
		return false;
	}

	QFileInfo fi2(m_page1->docfinallocation->text());

	if ( fi2.exists() )
	{
		m_page1->validlabel->setText( i18n("(invalid : project already exists)") );
		return false;
	}
	return true;
}

void generatorwizard::updatelocationlabel()
{
	QString base = m_page1->doclocation->url();
	if (!base.endsWith("/")) base.append("/");

	m_page1->docfinallocation->setText(base+m_page1->docname->text());
	checksteps();
	//isvalidlocation();
}

void generatorwizard::setgeneratorlist(QValueList<DGenerator*> & genlist)
{
	for (unsigned int i=0; i<genlist.count(); i++)
	{
		QString group = genlist[i]->group();
		QString fullname = genlist[i]->fullName();

		KListViewItem *item = (KListViewItem*) m_page1->templatelist->findItem(group, 0);
		if (item)
		{
			new KListViewItemGen(item, fullname, genlist[i]);
		}
		else
		{
			item = new KListViewItemGen(m_page1->templatelist, group, NULL);
			item->setPixmap(0, SmallIcon("folder"));
			item->setOpen(true);

			new KListViewItemGen(item, fullname, genlist[i]);
		}
	}
}

void generatorwizard::setgeneratordata(DDataControl* data)
{
	m_data = data;
}

void generatorwizard::updateselectedtemplate(QListViewItem* item)
{
	KListViewItemGen* gen = (KListViewItemGen*) item;
	if (gen->m_gen)
	{
		m_page1->templatedescr->setText( gen->m_gen->description() );	
		m_selected = gen->m_gen;
	}
	else
	{
		m_page1->templatedescr->setText( QString::null );
		m_selected = NULL;
	}
}

void generatorwizard::checksteps()
{
	// more steps to come ...
	bool valid = isvalidlocation();
	if (currentPage() == m_page1)
	{
		setNextEnabled(m_page1, m_selected && valid);
	}

	if (currentPage() == m_page2)
	{
		m_page2->url->setText(m_page1->docfinallocation->text());
		m_page2->notes->setText(m_selected->quickstart());
		setFinishEnabled(m_page2, valid);
		finishButton()->setFocus();
	}
}

#include "generatorwizard.moc"
