/** 
 * Copyright (C) 2000-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _INTERPRETER_DIALOG_H_
#define _INTERPRETER_DIALOG_H_

#include <qstring.h>
#include <kdialogbase.h>

class GeneralSettingsWidget;
class GSSettingsWidget;

class KGVConfigDialog : public KDialogBase 
{
    Q_OBJECT

public:
	// The indexes below match the ones on the designer generated dialog
    enum { ColorPalette = 3,
	    GrayPalette = 2,
	    MonoPalette = 1 };

    KGVConfigDialog( QWidget* parent = 0, const char* name = 0, 
		     bool modal = true );
    ~KGVConfigDialog();

    void setup();

    void readSettings();
    void writeSettings();

    bool    antiAlias()		const { return mAntialias; }
    bool    showMessages()	const { return mShowMessages; }
    bool    platformFonts()	const { return mPlatformFonts; }
    int	    paletteType()	const { return mPaletteType; }

    QString interpreterPath()	const { return mInterpreterPath; }
    QString nonAntialiasArgs()	const { return mNonAntiAliasArgs; }
    QString antialiasArgs()	const { return mAntiAliasArgs; }

protected slots:
    virtual void slotOk();
    virtual void slotDefault();

    bool slotConfigureGhostscript();

private:

    GeneralSettingsWidget *mGeneralWidget;
    GSSettingsWidget      *mGSWidget;

    bool    mAntialias;
    bool    mShowMessages;
    bool    mPlatformFonts;
    int	    mPaletteType;

    QString mInterpreterPath;
    QString mNonAntiAliasArgs;
    QString mAntiAliasArgs;
    QString mDetectedVersion;
};

#endif 


// vim:sw=4:sts=4:ts=8:noet
