// Qt# tutorial 6
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class LCDRange : QVBox {

	public LCDRange (QWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		QLCDNumber lcd = new QLCDNumber (2, this, "lcd" );
		QSlider slider = new QSlider (Orientation.Horizontal, this, "slider");
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, SIGNAL ("valueChanged(int)"), lcd, SLOT ("Display(int)") );
	}
	
	public LCDRange (QWidget parent) : this (parent, "") {}
	public LCDRange () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class MyWidget : QVBox {

	MyWidget (QWidget parent, String name) : base (parent, name)
	{
		QPushButton quit = new QPushButton ("Quit", this, "quit");
		quit.SetFont ( new QFont ("Times", 18, QFont.Weight.Bold) );
		
		Connect ( quit, SIGNAL ("clicked()"), qApp, SLOT ("Quit()") );
		
		QGrid grid = new QGrid (4, this);
		
		for ( int c =0; c < 4; c++ )
			for ( int r = 0; r < 4; r++ )
				new LCDRange (grid);
	}
	
	public MyWidget (QWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);

		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
