/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <limits.h>

#include <klibloader.h>
#include <klocale.h>
#include <ktrader.h>

#include <kbsboincmonitor.h>
#include <kbshostnode.h>
#include <kbspanelnode.h>
#include <kbsworkunitnode.h>

#include "kbscachenode.h"

KBSCacheNode::KBSCacheNode(KBSTreeNode *parent, const char *name)
            : KBSTreeNode(parent, name)
{
  setupMonitor();

  const BOINCClientState *state = m_monitor->state();
  if(NULL != state) addWorkunits(state->workunit.keys());
  
  addPlugins();
}

unsigned KBSCacheNode::type() const
{
  return(INT_MAX - 1);
}

QString KBSCacheNode::name() const
{
  return i18n("Cache");
}

QStringList KBSCacheNode::icons() const
{
  return QStringList("cache");
}

KBSBOINCMonitor *KBSCacheNode::monitor()
{
  return m_monitor;
}

void KBSCacheNode::addWorkunits(const QStringList &workunits)
{
  for(QStringList::const_iterator workunit = workunits.constBegin();
      workunit != workunits.constEnd(); ++workunit)
  {
    KBSWorkunitNode *node = new KBSWorkunitNode(*workunit, this);
    insertChild(node);
    
    m_workunits.insert(*workunit, node);
  }
}

void KBSCacheNode::removeWorkunits(const QStringList &workunits)
{
  for(QStringList::const_iterator workunit = workunits.constBegin();
      workunit != workunits.constEnd(); ++workunit)
  {
    KBSWorkunitNode *node = m_workunits.find(*workunit);
    if(NULL == node) continue;
    
    m_workunits.remove(*workunit);
    removeChild(node);
  }
}

void KBSCacheNode::setupMonitor()
{
  KBSHostNode *host = static_cast<KBSHostNode*>(findAncestor("KBSHostNode"));
  m_monitor = (NULL != host) ? host->monitor() : NULL;
  if(NULL == m_monitor) return;
  
  connect(m_monitor, SIGNAL(workunitsAdded(const QStringList &)),
          this, SLOT(addWorkunits(const QStringList &)));
  connect(m_monitor, SIGNAL(workunitsRemoved(const QStringList &)),
          this, SLOT(removeWorkunits(const QStringList &)));
}

void KBSCacheNode::addPlugins()
{
  const QString constraints = "[X-KDE-Target] == 'Cache'";
  KTrader::OfferList offers = KTrader::self()->query("KBSPanelNode", constraints);

  for(KTrader::OfferListIterator offer = offers.begin(); offer != offers.end(); ++offer)
  {
    QStringList args = (*offer)->property("X-KDE-Arguments").toStringList();
    
    KLibFactory *factory = KLibLoader::self()->factory((*offer)->library());
    if(NULL == factory) continue;
    
    insertChild(static_cast<KBSPanelNode*>(factory->create(this, 0, "KBSPanelNode", args)));
  }
}

#include "kbscachenode.moc"

