/* LocaleInformation_hy.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_hy extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "\u0545\u0576\u0580",
    "\u0553\u057f\u0580",
    "\u0544\u0580\u057f",
    "\u0531\u057a\u0580",
    "\u0544\u0575\u057d",
    "\u0545\u0576\u057d",
    "\u0545\u056c\u057d",
    "\u0555\u0563\u057d",
    "\u054d\u0565\u057a",
    "\u0540\u0578\u056f",
    "\u0546\u0578\u0575",
    "\u0534\u0565\u056f",
    null,
  };

  private static final String[] months = {
    "\u0545\u0578\u0582\u0576\u0578\u0582\u0561\u0580",
    "\u0553\u0565\u057f\u0580\u0578\u0582\u0561\u0580",
    "\u0544\u0561\u0580\u057f",
    "\u0531\u057a\u0580\u056b\u056c",
    "\u0544\u0561\u0575\u056b\u057d",
    "\u0545\u0578\u0582\u0576\u056b\u057d",
    "\u0545\u0578\u0582\u056c\u056b\u057d",
    "\u0555\u0563\u0578\u057d\u057f\u0578\u057d",
    "\u054d\u0565\u057a\u057f\u0565\u0574\u0562\u0565\u0580",
    "\u0540\u0578\u056f\u057f\u0565\u0574\u0562\u0565\u0580",
    "\u0546\u0578\u0575\u0565\u0574\u0562\u0565\u0580",
    "\u0534\u0565\u056f\u057f\u0565\u0574\u0562\u0565\u0580",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u053f\u056b\u0580",
    "\u0535\u0580\u056f",
    "\u0535\u0580\u0584",
    "\u0549\u0578\u0580",
    "\u0540\u0576\u0563",
    "\u0548\u0582\u0580",
    "\u0547\u0561\u0562",
  };

  private static final String[] weekdays = {
    null,
    "\u053f\u056b\u0580\u0561\u056f\u056b",
    "\u0535\u0580\u056f\u0578\u0582\u0577\u0561\u0562\u0569\u056b",
    "\u0535\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b",
    "\u0549\u0578\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b",
    "\u0540\u056b\u0576\u0563\u0577\u0561\u0562\u0569\u056b",
    "\u0548\u0582\u0580\u0562\u0561\u0569",
    "\u0547\u0561\u0562\u0561\u0569",
  };

  private static final String[] eras = {
    "\u0545\u2024\u054f\u2024",
    "\u0546\u2024\u0554\u2024",
  };

  private static final String[] ampms = {
    "\u0531\u057c\u2024",
    "\u0535\u0580\u2024",
  };

  private static final String territoriesKeys = "TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GT\u00A6GR\u00A6GQ\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6SV\u00A6ST\u00A6GH\u00A6SR\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SI\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6DE\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6AZ\u00A6NE\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6MZ\u00A6AO\u00A6MY\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6MR\u00A6AG\u00A6AF\u00A6AE\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6TW\u00A6TV\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "\u054f\u0561\u0573\u056b\u056f\u057d\u057f\u0561\u0576\u00A6\u0539\u0561\u056b\u056c\u0561\u0576\u0564\u00A6\u054f\u0578\u0563\u0578\u00A6\u0533\u0561\u0575\u0561\u0576\u0561\u00A6\u0549\u0561\u0564\u00A6\u0533\u057e\u056b\u0576\u0565\u0561-\u0532\u056b\u057d\u0561\u0578\u0582\u00A6\u0533\u057e\u0561\u057f\u0565\u0574\u0561\u056c\u0561\u00A6\u0540\u0578\u0582\u0576\u0561\u057d\u057f\u0561\u0576\u00A6\u0540\u0561\u057d\u0561\u0580\u0561\u056f\u0561\u056e\u0561\u0575\u056b\u0576 \u0533\u057e\u056b\u0576\u0565\u0561\u00A6\u054d\u057e\u0561\u0566\u056b\u056c\u0565\u0576\u0564\u00A6\u054d\u056b\u0580\u056b\u0561\u00A6\u0533\u057e\u056b\u0576\u0565\u0561\u00A6\u0533\u0561\u0574\u0562\u056b\u0561\u00A6\u054d\u0561\u056c\u057e\u0561\u0564\u0578\u0580\u00A6\u054d\u0561\u0576-\u0539\u0578\u0574\u0565-\u0553\u0580\u056b\u0576\u057d\u056b\u057a\u056b\u00A6\u0533\u0561\u0576\u0561\u00A6\u054d\u0578\u0582\u0580\u056b\u0576\u0561\u0574\u00A6\u054e\u0580\u0561\u057d\u057f\u0561\u0576\u00A6\u054d\u0578\u0574\u0561\u056c\u056b\u00A6\u0533\u0580\u0565\u0576\u0561\u0564\u0561\u00A6\u054d\u0565\u0576\u0565\u0563\u0561\u056c\u00A6\u054d\u0561\u0576 \u0544\u0561\u0580\u056b\u0576\u0578\u00A6\u0544\u0565\u056e \u0532\u0580\u056b\u057f\u0561\u0576\u056b\u0561\u00A6\u054d\u0575\u0565\u0580\u0561-\u053c\u0565\u0578\u0576\u0565\u00A6\u0533\u0561\u0562\u0578\u0576\u00A6\u054d\u056c\u0578\u057e\u0561\u056f\u056b\u0561\u00A6\u054d\u056c\u0578\u057e\u0565\u0576\u056b\u0561\u00A6\u054d\u056b\u0576\u0563\u0561\u057a\u0578\u0582\u0580\u00A6\u0547\u057e\u0565\u0564\u056b\u0561\u00A6\u054d\u0578\u0582\u0564\u0561\u0576\u00A6\u054d\u0565\u0575\u0577\u0565\u056c\u0576\u0565\u0580\u00A6\u054d\u0578\u056c\u0578\u0574\u0578\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u00A6\u054d\u0561\u0578\u0582\u0564\u056b\u0561\u0576 \u0531\u0580\u0561\u0562\u056b\u0561\u00A6\u0556\u0580\u0561\u0576\u057d\u056b\u0561\u00A6\u0544\u056b\u056f\u0580\u0578\u0576\u0565\u0566\u056b\u0561\u00A6\u054c\u0578\u0582\u0561\u0576\u0564\u0561\u00A6\u054c\u0578\u0582\u057d\u0561\u057d\u057f\u0561\u0576\u00A6\u0556\u056b\u057b\u056b\u00A6\u0556\u056b\u0576\u056c\u0561\u0576\u0564\u056b\u0561\u00A6\u054c\u0578\u0582\u0574\u056b\u0576\u056b\u0561\u00A6\u0535\u0569\u0578\u057e\u057a\u056b\u0561\u00A6\u053b\u057d\u057a\u0561\u0576\u056b\u0561\u00A6\u0537\u0580\u056b\u057f\u0580\u0565\u0561\u00A6\u0531\u0580\u0565\u057e\u0574\u057f\u0575\u0561\u0576 \u054d\u0561\u0570\u0561\u0580\u0561\u00A6\u0535\u0563\u056b\u057a\u057f\u0578\u057d\u00A6\u0537\u057d\u057f\u0578\u0576\u056b\u0561\u00A6\u0537\u056f\u057e\u0561\u0564\u0578\u0580\u00A6\u0531\u056c\u056a\u056b\u0580\u00A6\u053f\u0561\u057f\u0561\u0580\u00A6\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u00A6\u054a\u0561\u0580\u0561\u0563\u057e\u0561\u0575\u00A6\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0561\u00A6\u054a\u0561\u056c\u0561\u0578\u0582\u00A6\u0534\u0561\u0576\u056b\u0561\u00A6\u054b\u056b\u0562\u0578\u0582\u057f\u056b\u00A6\u054a\u0578\u0580\u057f\u0578\u0582\u0563\u0561\u056c\u056b\u0561\u00A6\u0533\u0565\u0580\u0574\u0561\u0576\u056b\u0561\u00A6\u053c\u0565\u0570\u0561\u057d\u057f\u0561\u0576\u00A6\u054a\u0561\u056f\u056b\u057d\u057f\u0561\u0576\u00A6\u0556\u056b\u056c\u056b\u057a\u056b\u0576\u0576\u0565\u0580\u00A6\u054a\u0561\u057a\u0578\u0582\u0561 \u0546\u0578\u0580 \u0533\u057e\u056b\u0576\u0565\u0561\u00A6\u0549\u0565\u056d\u056b\u0561\u0575\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u00A6\u054a\u0565\u0580\u0578\u0582\u00A6\u053f\u056b\u057a\u0580\u0578\u057d\u00A6\u053f\u0561\u0562\u0578-\u054e\u0565\u0580\u0564\u0565\u00A6\u054a\u0561\u0576\u0561\u0574\u0561\u00A6\u053f\u0578\u0582\u0562\u0561\u00A6\u053f\u0578\u057d\u057f\u0561-\u054c\u056b\u056f\u0561\u00A6\u053f\u0578\u056c\u0578\u0582\u0574\u0562\u056b\u0561\u00A6\u0549\u056b\u0576\u0561\u057d\u057f\u0561\u0576\u00A6\u053f\u0561\u0574\u0565\u0580\u0578\u0582\u0576\u00A6\u0549\u056b\u056c\u056b\u00A6\u0553\u0572\u0578\u057d\u056f\u0580\u056b \u0531\u0583\u00A6\u0547\u057e\u0565\u0575\u0581\u0561\u0580\u056b\u0561\u00A6\u053f\u0578\u0576\u0563\u0578\u00A6\u053f\u0565\u0576\u057f\u0580\u0578\u0576\u0561\u056f\u0561\u0576 \u0531\u0586\u0580\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u00A6\u0555\u0574\u0561\u0576\u00A6\u053f\u0561\u0576\u0561\u0564\u0561\u00A6\u0532\u0565\u056c\u056b\u0566\u00A6\u0532\u0565\u056c\u0578\u057c\u0578\u0582\u057d\u00A6\u0532\u0578\u057f\u057d\u057e\u0561\u0576\u0561\u00A6\u0532\u0578\u0582\u057f\u0561\u0576\u00A6\u0532\u0561\u0570\u0561\u0574\u0576\u0565\u0580\u00A6\u0532\u0580\u0561\u0566\u056b\u056c\u056b\u0561\u00A6\u0546\u0578\u0580 \u0536\u0565\u056c\u0561\u0576\u0564\u056b\u0561\u00A6\u0532\u0578\u056c\u056b\u057e\u056b\u0561\u00A6\u0532\u0580\u0578\u0582\u0576\u0565\u0575\u00A6\u0532\u0565\u0576\u056b\u0576\u00A6\u0532\u0578\u0582\u0580\u0578\u0582\u0576\u0564\u056b\u00A6\u0532\u0561\u0570\u0580\u0565\u0575\u0576\u00A6\u0546\u0561\u0578\u0582\u0580\u0578\u0582\u00A6\u0532\u0578\u0582\u056c\u0572\u0561\u0580\u056b\u0561\u00A6\u0532\u0578\u0582\u0580\u056f\u056b\u0576\u0561 \u0556\u0561\u057d\u0578\u00A6\u0546\u0565\u057a\u0561\u056c\u00A6\u0532\u0565\u056c\u0563\u056b\u0561\u00A6\u0546\u0578\u0580\u057e\u0565\u0563\u056b\u0561\u00A6\u0532\u0561\u0576\u0563\u056c\u0561\u0564\u0565\u0577\u00A6\u0532\u0561\u0580\u0562\u0561\u0564\u0578\u057d\u00A6\u0536\u056b\u0574\u0562\u0561\u0562\u057e\u0565\u00A6\u0546\u056b\u0564\u0565\u0580\u056c\u0561\u0576\u0564\u0565\u0580\u00A6\u0532\u0578\u057d\u0576\u056b\u0561-\u0540\u0565\u0580\u0581\u0565\u0563\u0578\u057e\u056b\u0576\u0561\u00A6\u0546\u056b\u056f\u0561\u0580\u0561\u0563\u0578\u0582\u0561\u00A6\u0546\u056b\u0563\u0565\u0580\u056b\u0561\u00A6\u0531\u0564\u0580\u0562\u0565\u057b\u0561\u0576\u00A6\u0546\u056b\u0563\u0565\u0580\u00A6\u0536\u0561\u0574\u0562\u056b\u0561\u00A6\u0531\u057e\u057d\u057f\u0580\u0561\u056c\u056b\u0561\u00A6\u0546\u0561\u0574\u056b\u0562\u056b\u0561\u00A6\u0531\u057e\u057d\u057f\u0580\u056b\u0561\u00A6\u0531\u0580\u0563\u0565\u0576\u057f\u056b\u0576\u0561\u00A6\u0544\u0578\u0566\u0561\u0574\u0562\u056b\u056f\u00A6\u0531\u0576\u0563\u0578\u056c\u0561\u00A6\u0544\u0561\u056c\u0561\u0575\u0566\u056b\u0561\u00A6\u0544\u0565\u0584\u057d\u056b\u056f\u0561\u00A6\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u056b\u0582\u0576\u00A6\u0544\u0561\u056c\u0561\u057e\u056b\u00A6\u0531\u056c\u0562\u0561\u0576\u056b\u0561\u00A6\u0544\u0561\u056c\u0564\u056b\u057e\u0576\u0565\u0580\u00A6\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u0531\u0586\u0580\u056b\u056f\u0561\u00A6\u0544\u0561\u057e\u0580\u056b\u057f\u0578\u057d\u00A6\u0544\u0561\u056c\u0569\u0561\u00A6\u0544\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u056b\u0561\u00A6\u0531\u0576\u057f\u056b\u0563\u0578\u0582\u0561-\u0532\u0561\u0580\u0562\u0578\u0582\u0564\u0561\u00A6\u0531\u0586\u0572\u0561\u0576\u057d\u057f\u0561\u0576\u00A6\u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0531\u0580\u0561\u0562\u0561\u056f\u0561\u0576 \u0537\u0574\u056b\u0580\u0561\u0569\u0576\u0565\u0580\u00A6\u0531\u0576\u0564\u0578\u0580\u0561\u00A6\u0544\u0578\u0576\u0572\u0578\u056c\u056b\u0561\u00A6\u0544\u0575\u0561\u0576\u0574\u0561\u00A6\u0544\u0561\u056c\u056b\u00A6\u0544\u0561\u056f\u0565\u0564\u0578\u0576\u056b\u0561\u00A6\u054d\u0565\u0580\u0562\u056b\u0561\u00A6\u0544\u0561\u0580\u0577\u0561\u056c\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u00A6\u0544\u0561\u0564\u0561\u0563\u0561\u057d\u056f\u0561\u0580\u00A6\u0544\u0578\u056c\u0564\u0578\u057e\u0561\u00A6\u0544\u0578\u0576\u0561\u056f\u0578\u00A6\u0544\u0561\u0580\u0578\u056f\u0578\u00A6\u0535\u0574\u0565\u0576\u00A6\u053c\u056b\u0562\u056b\u0561\u00A6\u053c\u0561\u057f\u057e\u056b\u0561\u00A6\u053c\u0575\u0578\u0582\u0584\u057d\u0565\u0574\u0562\u0578\u0582\u0580\u0563\u00A6\u053c\u056b\u057f\u057e\u0561\u00A6\u053c\u0565\u057d\u0578\u057f\u0578\u00A6\u053c\u056b\u0562\u0565\u0580\u056b\u0561\u00A6\u0547\u0580\u056b \u053c\u0561\u0576\u056f\u0561\u00A6\u053c\u056b\u056d\u057f\u0565\u0576\u0577\u057f\u0565\u0575\u0576\u00A6\u054d\u0561\u0576\u057f\u0561 \u053c\u0578\u0582\u0579\u056b\u0561\u00A6\u053c\u056b\u0562\u0561\u0576\u0561\u0576\u00A6\u053c\u0561\u0578\u057d\u00A6\u0542\u0561\u0566\u0561\u056d\u057d\u057f\u0561\u0576\u00A6\u0554\u0578\u0582\u057e\u0565\u0575\u0569\u00A6\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561\u00A6\u0540\u0575\u0578\u0582\u057d\u056b\u057d\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561\u00A6\u054d\u0565\u0576\u057f \u053f\u056b\u057f\u057d-\u0546\u0565\u057e\u056b\u057d\u00A6\u053f\u0578\u0574\u0578\u0580\u0578\u057d\u00A6\u053f\u056b\u0580\u056b\u0562\u0561\u057f\u056b\u00A6\u054d\u0561\u0574\u0578\u0561\u00A6\u053f\u0561\u0574\u0562\u0578\u057b\u0561\u00A6\u053f\u056b\u0580\u0563\u056b\u0566\u057d\u057f\u0561\u0576\u00A6\u0554\u0565\u0576\u056b\u0561\u00A6\u0543\u0561\u057a\u0578\u0576\u056b\u0561\u00A6\u0540\u0578\u0580\u0564\u0561\u0576\u0561\u0576\u00A6\u054b\u0561\u0574\u0561\u0575\u056f\u0561\u00A6\u054e\u0561\u0576\u0578\u0582\u0561\u057f\u0578\u0582\u00A6\u054e\u056b\u0565\u057f\u0576\u0561\u0574\u00A6\u054e\u0565\u0576\u0565\u057d\u0578\u0582\u0565\u056c\u0561\u00A6\u054d\u0565\u0576\u057f \u054e\u056b\u057d\u0565\u0576\u057f-\u0533\u0580\u0565\u0576\u0561\u0564\u056b\u0576\u0576\u0565\u0580\u00A6\u054e\u0561\u057f\u056b\u056f\u0561\u0576\u00A6\u053b\u057f\u0561\u056c\u056b\u0561\u00A6\u053b\u057d\u056c\u0561\u0576\u0564\u056b\u0561\u00A6\u053b\u0580\u0561\u0576\u00A6\u053b\u0580\u0561\u0584\u00A6\u0548\u0582\u0566\u0562\u0565\u056f\u057d\u057f\u0561\u0576\u00A6\u0548\u0582\u0580\u0578\u0582\u0563\u057e\u0561\u0575\u00A6\u0540\u0576\u0564\u056f\u0561\u057d\u057f\u0561\u0576\u00A6\u053b\u057d\u0580\u0561\u0575\u0565\u056c\u00A6\u0531\u0574\u0567\u0580\u056b\u056f\u0561\u0575\u056b \u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0546\u0561\u0570\u0561\u0576\u0563\u0576\u0567\u0580\u00A6\u053b\u057c\u056c\u0561\u0576\u0564\u056b\u0561\u00A6\u053b\u0576\u0564\u0578\u0576\u0565\u0566\u056b\u0561\u00A6\u0548\u0582\u0563\u0561\u0576\u0564\u0561\u00A6\u0548\u0582\u056f\u0580\u0561\u056b\u0576\u0561\u00A6\u0540\u0578\u0582\u0576\u0563\u0561\u0580\u056b\u0561\u00A6\u0540\u0561\u056b\u0569\u056b\u00A6\u0540\u0578\u0580\u057e\u0561\u0569\u056b\u0561\u00A6\u054f\u0561\u0576\u0566\u0561\u0576\u056b\u0561\u00A6\u0540\u0578\u0576\u0564\u0578\u0582\u0580\u0561\u057d\u00A6\u0539\u0561\u0575\u057e\u0561\u0576\u00A6\u054f\u0578\u0582\u057e\u0561\u056c\u0578\u0582\u00A6\u054f\u0580\u056b\u0576\u056b\u0564\u0561\u0564-\u054f\u0578\u0562\u0561\u0563\u0578\u00A6\u0539\u0578\u0582\u0580\u0584\u056b\u0561\u00A6\u054f\u0578\u0576\u0563\u0561\u00A6\u0539\u0578\u0582\u0576\u056b\u057d\u00A6\u0539\u0578\u0582\u0580\u0584\u0574\u0565\u0576\u057d\u057f\u0561\u0576";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "hy";

  private static final String languagesValues = "\u0540\u0561\u0575\u0565\u0580\u0567\u0576";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "percentFormat", "#0%" },
    { "currencyFormat", "#0.00 \u00a4;-#0.00 \u00a4" },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "firstDayOfWeek", "mon" },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "MM/dd/yy" },
    { "mediumDateFormat", "MMM d, yyyy" },
    { "longDateFormat", "MMMM dd, yyyy" },
    { "fullDateFormat", "EEEE, MMMM d, yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
