
/*
 * utils.h -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_UTILS_H
#define DIALOGS_UTILS_H

/*
 * Canonicalize path, and return a new path. The new path is
 * an absolute path (in it's simplest form). Returns 0 if
 * successful, -1 if an error occurred. check errno to see
 * what error occurred.
 *
 * ERRORS:
 *    ERANGE     path is to small, increase size (should be PATH_MAX anyway)
 *    ENOMEM     out of memory
 *
 * WORKINGS:
 *    Multiple /'s are collapsed to a single /'.
 *    .'s is replaced with the current working directory.
 *    ..'s are handled by removing portions of the path.
 *    Trailing /'s are removed.
 */
#ifndef CUSTOM_CWD
int canonicalize_pathname (char *path,size_t size);
#else
int canonicalize_pathname (char *path,size_t size,const char *cwd);
#endif

#endif
