#ifndef _IMG_C
#define _IMG_C

#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <math.h>

inline void
img_set_pixel_xy ( uint8_t *data , int w , int x , int y , const uint8_t *pixel )
{
  int n = ( ( w * y ) + x ) * 3 ;
  memcpy ( data + n , pixel , 3 ) ;
}

inline int
signal_x_to_screen_x ( float x , int width ) 
{
  float xx = ( x / 2.0 ) + 0.5 ;
  return floorf ( xx * (float)width ) ;
}

inline int
signal_y_to_screen_y ( float y , int height ) 
{
  float yy = 1.0 - ( ( y / 2.0 ) + 0.5 ) ;
  return floorf ( yy * (float)height ) ;
}

void
img_write_ppm ( const uint8_t *data , int w , int h , FILE *fp )
{
  fprintf ( fp , "P6 %d %d 255\n" , w , h ) ;
  fwrite ( data , w * h , 3 , fp ) ;
}

void
img_write_ppm_file ( const uint8_t *data , int w , int h , const char *name )
{
  FILE *fp = fopen ( name , "w" ) ;
  if ( !fp ) {
    fprintf ( stderr , "fopen() failed,%s\n" , name ) ;
    FAILURE ;
  }
  img_write_ppm ( data , w , h , fp ) ;
  fclose ( fp ) ;
}

#endif
