#****************************************************************************
#*                          WaveScrollWidget.tcl
#*
#* Author: Matthew Ballance
#* Desc: 
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

namespace eval WaveScrollWidget {

    variable d_configspec {
        { "-wave_widget"            ""}
    }

    variable d_pi 3.14159265359
    variable d_2pi [expr $d_pi * 2]
}


#********************************************************************
#* WaveScrollWidget
#********************************************************************
proc WaveScrollWidget::WaveScrollWidget {menu path args} {
    variable d_configspec
    global   CurrWaveWindow

    set path [frame $menu.$path]

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval WaveScrollWidget::cmd \$cmd \$args\]"

    array set $path {_dummy _dummy}
    upvar #0 $path data

    BaseClass::config_init $path $d_configspec
    eval BaseClass::configure $path $args

    set scale_pane [WaveScrollWidget::ConstructScalePane \
        $path $path.scale_pane]

    set bg_color [$scale_pane cget -background]

    set data(w:knob) [Knob::Knob $path.knob \
        -command "WaveScrollWidget::KnobMove $path" \
        -bg $bg_color \
        -dot_color   "yellow" \
        -knob_radius 8 -dot_radius 2]

    set data(units_rev)    1
    set data(acc_rad)      0

    set data(wave_window) $CurrWaveWindow

    pack $data(w:knob) $scale_pane -side left

    pack $path -side left -padx 4 -anchor w
    return $path
}

#********************************************************************
#* ConstructScalePane
#********************************************************************
proc WaveScrollWidget::ConstructScalePane {w pane} {
    upvar #0 $w data

    set pane [frame $pane]

    set radio_var $w.radio_var
    upvar #0 $radio_var rv
    set rv "pages_rev"

    set data(w:pages_rev) [radiobutton $pane.pages_rev \
        -value "pages_rev" -variable $radio_var -text "Pg/Rev"]
    set data(w:rev_page) [radiobutton $pane.rev_page \
        -value "rev_page" -variable $radio_var -text "Rev/Pg"]
    set data(w:spin)     [SpinBox $pane.spin \
        -range [list 1 100 1] -width 2 \
        -modifycmd "WaveScrollWidget::ScaleModifyCmd $w" -editable false]

    trace variable "$w.trace_var" w "WaveScrollWidget::ScaleModifyCmd $w"

#    pack $data(w:pages_rev) $data(w:rev_page) $data(w:spin) 
    grid $data(w:pages_rev) $data(w:rev_page) $data(w:spin) 

    return $pane
}

#********************************************************************
#* KnobMove
#********************************************************************
proc WaveScrollWidget::KnobMove {w new_rad rad_delta} {
    upvar #0 $w data
    upvar #0 $w.radio_var radio_var
    variable d_pi


    set data(acc_rad) [expr $data(acc_rad) + $rad_delta]

    set curr_zoom [WaveWindow::Zoom $data(wave_window) get]
    set x0 [lindex $curr_zoom 0]
    set x1 [lindex $curr_zoom 1]
    set wave_size [expr $x1 - $x0]

    set rad_acc    [expr (1.0/(2*$d_pi)) * $data(acc_rad)]

    if {$radio_var == "pages_rev"} {
        set unit_delta [expr ($data(units_rev) * $wave_size) * $rad_acc]
    } else {
        set unit_delta [expr ($wave_size * $rad_acc) / $data(units_rev)]
    }

    if {$unit_delta > 1 || $unit_delta < -1} {
        set data(acc_rad) 0

        set unit_delta [expr round($unit_delta)]

        set x0 [expr $unit_delta + $x0]
        set x1 [expr $unit_delta + $x1]

        if {$x0 < 0} {
            set x1 [expr $x1 - $x0]
            set x0 0
        }

#        wave zoom $x0 $x1
        WaveWindow::Zoom $data(wave_window) range_quiet $x0 $x1
    }
}

#********************************************************************
#* ScaleModifyCmd
#********************************************************************
proc WaveScrollWidget::ScaleModifyCmd {w} {
    upvar #0 $w data

    set new_units [$data(w:spin) getvalue]

    if {$new_units > 0} {
        set data(units_rev) $new_units
    }
}

