/****************************************************************************
 *                               DFIOValChg.h
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#ifndef INCLUDED_DFIO_VAL_CHG_H
#define INCLUDED_DFIO_VAL_CHG_H
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
 * DFIOVal
 *
 * Describes a value or array of values
 ********************************************************************/
typedef struct DFIOVal {
    Uint8        aval;
    Uint8        bval;
} DFIOVal, DFIOVal8;

/********************************************************************
 * DFIOVal32
 ********************************************************************/
typedef struct DFIOVal32 {
    Uint32       aval;
    Uint32       bval;
} DFIOVal32;

/********************************************************************
 * DFIOValChg
 *
 ********************************************************************/
typedef struct DFIOValChg {
    union {
        Uint32    changeTime;
        Uint64    changeTime64;
    };
    DFIOVal   bitVal[1];
} DFIOValChg;

/********************************************************************
 * DFIOValChg_Size()
 *
 * Returns the size of an array of DFOValChg structures
 ********************************************************************/
Uint32 DFIOValChg_Size(Uint32 bitwidth, Uint32 count);

/********************************************************************
 * DFIOBitVal
 ********************************************************************/
typedef enum {
    DFIOBitVal_0 = 0,
    DFIOBitVal_1 = 1,
    DFIOBitVal_Z = 2,
    DFIOBitVal_X = 3
} DFIOBitVal;

/********************************************************************
 * DFIOValChg_SetBit()
 ********************************************************************/
void DFIOValChg_SetBit(DFIOValChg *chg, Uint32 bit, DFIOBitVal val);

/********************************************************************
 * DFIOValChg_GetBit()
 ********************************************************************/
DFIOBitVal DFIOValChg_GetBit(const DFIOVal *chg, Uint32 bit);

/********************************************************************
 * DFIOValChg_Dump()
 ********************************************************************/
void DFIOValChg_Dump(const DFIOVal *chg, Uint32 bit);

/**********************************************************
 * DFIOValChg_Idx()
 **********************************************************/
DFIOValChg *DFIOValChg_Idx(DFIOValChg *chgs, Uint32 width, Uint32 idx);

#ifdef __cplusplus
};
#endif

#endif /* INCLUDED_DFIO_VAL_CHG_H */
