/*****************************************************************************
 *                            CallbackType.cc
 * 
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#include "CallbackType.h"
#include "CallbackMgr.h"
#include "CallbackList.h"
#include "Callback.h"

/********************************************************************
 * CallbackType
 ********************************************************************/
CallbackType::CallbackType(const char *typeName, CallbackMgr *mgr) :
    d_typeName(typeName)
{
    this->mgr = mgr;
    Tcl_InitHashTable(&instHashTab, TCL_STRING_KEYS);
}


/********************************************************************
 * get_interp()
 ********************************************************************/
Tcl_Interp *CallbackType::get_interp()
{
    return mgr->get_interp();
}

/********************************************************************
 * AddCb()
 ********************************************************************/
void CallbackType::AddCb(const char *instName, Callback *cb)
{
    Tcl_HashEntry   *entry;
    Int32            tmpi;
    CallbackList    *cbList;
    const char      *iName;

    iName = (instName)?instName:"null";

    /**** Add this callback to the appropriate list of the instance
     **** hash table...
     ****/

    cb->set_type(this);

    if (!(entry = Tcl_FindHashEntry(&instHashTab, iName))) {
        entry = Tcl_CreateHashEntry(&instHashTab, iName, &tmpi);
        
        /**** Create a new callback list... ****/
        cbList = new CallbackList(iName, this);
        Tcl_SetHashValue(entry, cbList);
    } else {
        cbList = (CallbackList *)Tcl_GetHashValue(entry);
    }
   
    cbList->AddCb(cb);
}

/********************************************************************
 * GetCbList()
 ********************************************************************/
CallbackList *CallbackType::GetCbList(const char *cbInstName)
{
    const char      *iName;
    Tcl_HashEntry   *entry;
    CallbackList    *cbList;

    iName = (cbInstName)?cbInstName:"null";

    if (!(entry = Tcl_FindHashEntry(&instHashTab, iName))) {
        int tmpi;

        entry = Tcl_CreateHashEntry(&instHashTab, iName, &tmpi);
        
        /**** Create a new callback list... ****/
        cbList = new CallbackList(iName, this);
        Tcl_SetHashValue(entry, cbList);
    } else {
        cbList = (CallbackList *)Tcl_GetHashValue(entry);
    }

    return cbList;
}

/********************************************************************
 * Invoke()
 ********************************************************************/
int CallbackType::Invoke(const char *cbInst, Uint32 argc, 
        Tcl_Obj *const objv[])
{
    CallbackList    *cbLst;
    Tcl_HashEntry   *entry;
    const char      *iName = (cbInst)?cbInst:"null";

    if (!(entry = Tcl_FindHashEntry(&instHashTab, iName))) {
        return TCL_ERROR;
    }

    cbLst = (CallbackList *)Tcl_GetHashValue(entry);

    if (cbLst) {
        cbLst->Invoke(argc, objv);
    }
}

/********************************************************************
 * Disable()
 ********************************************************************/
int CallbackType::Disable(const char *cbInst)
{
    CallbackList    *cbLst;
    Tcl_HashEntry   *entry;
    const char      *iName = (cbInst)?cbInst:"null";

    if (!(entry = Tcl_FindHashEntry(&instHashTab, iName))) {
        return TCL_ERROR;
    }

    cbLst = (CallbackList *)Tcl_GetHashValue(entry);

    if (cbLst) {
        cbLst->Disable();
    }
}

/********************************************************************
 * Enable()
 ********************************************************************/
int CallbackType::Enable(const char *cbInst)
{
    CallbackList    *cbLst;
    Tcl_HashEntry   *entry;
    const char      *iName = (cbInst)?cbInst:"null";

    if (!(entry = Tcl_FindHashEntry(&instHashTab, iName))) {
        return TCL_ERROR;
    }

    cbLst = (CallbackList *)Tcl_GetHashValue(entry);

    if (cbLst) {
        cbLst->Enable();
    }
}


