#!/bin/sh
#-------------------------------------------------------------------------------
# Project:     IVI - Icarus Verilog Interactive
# File:        build.command
# Description: Script to build IVI on Mac OS X 10.3 (Panther)
#-------------------------------------------------------------------------------

macosx=`dirname $0`
cd ${macosx}

cd ..
ivi_src=`pwd`
ivi=`basename ${ivi_src}`

# alternative solution to gather version info:
#echo `more ${ivi_obj}/src/ivi_ui/tcl/version.tcl` | \
#	sed -e 's/.*set version //' | \
#	sed -e 's/ proc.*//' > ${ivi_inst}/VERSION.txt

cd ${macosx}

ivi_obj=${macosx}/build
ivi_inst=/Developer/Simulator/IVI

ivi_app=${ivi_inst}/IVI.app
ivi_home=${ivi_app}/Contents

CPATH=${ivi_home}/include
export CPATH

LIBRARY_PATH=${ivi_src}/src/common
export LIBRARY_PATH

# depends on Panther!
MACOSX_DEPLOYMENT_TARGET="10.3"
export MACOSX_DEPLOYMENT_TARGET

echo "----------------------------------------"
echo "App Package"
echo "----------------------------------------"

rm -rf ${ivi_inst}
mkdir ${ivi_inst}

#rm -rf ${ivi_app}
cp -r src/IVI_app ${ivi_app}

sed s/@RELEASE@/${ivi}/g src/IVI_app/Contents/Info.plist \
	> ${ivi_app}/Contents/Info.plist

echo "----------------------------------------"
echo "autoconf"
echo "----------------------------------------"

cd ${ivi_src}
./autoconf.sh

echo "----------------------------------------"
echo "configure"
echo "----------------------------------------"

#	--with-osx-deployment-target=<version>
#	--with-iverilog=${ivi_home} \
#  --bindir=DIR           user executables [EPREFIX/bin]

cd ${macosx}
mkdir build
cd build
${ivi_src}/configure \
	--enable-release \
	--prefix=${ivi_home} \
	--with-tcl=/Library/Frameworks/Tcl.framework \
	--with-tclinclude=/Library/Frameworks/Tcl.framework/Headers \
	--with-tk=/Library/Frameworks/Tk.framework \
	--with-tkinclude=/Library/Frameworks/Tk.framework/Headers \
	|| exit 1

echo "----------------------------------------"
echo "make"
echo "----------------------------------------"

make || exit 1

echo "----------------------------------------"
echo "install"
echo "----------------------------------------"

make install || exit 1
#rm ${ivi_app}/Contents/MacOS/ivi
ln -s ${ivi_home}/bin/ivi ${ivi_app}/Contents/MacOS/ivi

# --------------------------------------------
# copy additional files
# --------------------------------------------

#echo ${ivi} > ${ivi_inst}/VERSION.txt
echo ${ivi} | sed -e 's/ivi-//' > ${ivi_inst}/VERSION.txt

# move examples out of application package
#rm -rf ${ivi_inst}/examples
mv ${ivi_home}/examples ${ivi_inst}/examples

# add copy of GPL
cp ${ivi_src}/src/ivi_ui/tcl/License.txt ${ivi_inst}

# add credits
cp ${ivi_src}/src/ivi_ui/tcl/Credits.txt ${ivi_inst}

# add IVI release notes
cp ${ivi_src}/ReleaseNotes.txt ${ivi_inst}

# add Mac OS X readme
cp ${macosx}/Readme-OSX.txt ${ivi_inst}

# add Mac OS X documentation
cp ${macosx}/IVIonOSX.pdf ${ivi_inst}

echo "----------------------------------------"
echo "done"
echo "----------------------------------------"

#-------------------------------------------------------------------------------
# end of file

