#!/bin/sh
#
# Script to build Makefiles from Makefile.in
# Trying to be platform independant
# Author: dmytro Koval'ov <kov@tokyo.email.ne.jp>
# Date:   Dec, 7, 2000
#
#
# Changes: added 
#    * aspell parameter
#    * checking that ispell is actuall ispell
#    * checking that aspell/ispell exist
#        -DK, 25 jun'02
#
# Some default values:
CHARSET=`perl -e '$ENV{LANG}=~m/uk_UA\.(.*)$/i; print lc($1)'`;
if [ "$CHARSET" = "cp1251" ]; then
	DEFAULT=cp1251
else
	DEFAULT=koi
fi

if test "${ISPELL+set}" != set ; then 
    ISPELL="/usr/lib/ispell"
    # Need to have real ispell rather then aspell-emulation.
    ispell -v | grep -i aspell 1>&2 > /dev/null
    [ $? = 0 ] && {\
	printf "\n\n      **** ATTENTION **** \n\n"
	printf "Can not use aspell emulation for generating dictionaries.\n"
	printf "Please install real ispell then continue.\n\n\n"
	exit 1; }
fi

if test "${ASPELL+set}" != set ; then 
    ASPELL="/usr/lib/aspell"
fi
#ISPELL="/usr/lib/ispell" # default ispell directory

#
while [ ! "$1" = "" ] 
do
	case $1 in
		-default=*)
		DEFAULT=`echo $1 | cut -f2 -d=`
		;;
		-ispell=*)
		ISPELL=`echo $1 | cut -f2 -d=`
		;;
		-aspell=*)
		ASPELL=`echo $1 | cut -f2 -d=`
		;;
		*|-h)
		echo "Unknown parameter"
		cat <<EOF
	Usage: `basename $0`: [parameters]
		Parameters are:
		 -default=<CODE>, where CODE is: (koi|cp1251|cp1125).
		 	Without parameter koi used.
		 -ispell=<DIR>,
		 	Directory to install ispell dictionary and 
			affix files. Default is "/usr/lib/ispell".
		 -aspell=<DIR>,
		 	Directory to install aspell dictionary.
			Default is "/usr/lib/aspell", if this does not exist
			then all related to aspell will not be used.
EOF
		exit 1;
		;;
	esac
	shift
done

[ ! -d ${ISPELL} ] && { ISPELL="-NOT-INSTALLED-"; }
[ ! -d ${ASPELL} ] && { ASPELL="-NOT-INSTALLED-"; }



PERL=`which perl`   		# where is your perl
[ "${PERL}" = "" ] && { \
	echo "Can't find perl. Please make sure path to it included in your PATH";
	exit 1;
}
#
# All bin files are here
#
[ -d ./bin ] && { BIN=`(cd bin>/dev/null; pwd)`; }

[ "$BIN" = "" ] && { \
	echo "Can't find ./bin directory. Please check your installation"; \	
	exit 1;}

#
# Building makefiles
cat<<EOF
Creating Makefiles with following:

perl		 :	${PERL}
./bin		 : 	${BIN}
default codepage : 	${DEFAULT}
ispell directory :	${ISPELL}
aspell directory :	${ASPELL}

EOF

find . -name "Makefile.in" -print | 
while read MAKEFILEIN
	do 
		MAKEFILE=`echo ${MAKEFILEIN} | sed 's/.in$//'`
		[ "${MAKEFILE}" = "" ] || {
			cat $MAKEFILEIN | sed "
			s;__PERL__;${PERL};
			s;__BIN__;${BIN};
			s;__ISPELL__;${ISPELL};
			s;__ASPELL__;${ASPELL};
			s;__DEFAULT__;${DEFAULT};
			" > ${MAKEFILE}
		}
	done
# --- ALL DONE --
