<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################
include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");

commonHeader(_("Group Setup"));

__("Welcome to the IRM Group Setup utility.  Here you can change, view, delete, and add computer groups to the IRM database.");
printf('<a href="#add">%s</a>', _("Add Groups"));
echo "<hr noshade>";

$query = "SELECT * FROM groups";
$DB = Config::Database();
$data = $DB->getAll($query);
foreach ($data as $result)
{
  	$id = $result["ID"];
  	$groupname = $result["name"];
  	PRINT '<form method=post action="'
  		.Config::AbsLoc('users/setup-groups-update.php').'">';
	PRINT "<table width=100% border=1 noshade bordercolor=#000000>
		<tr bgcolor=#CCCCCC><td colspan=2><strong>($id) $groupname
		</strong></td></tr>";
  	PRINT "<tr bgcolor=#DDDDDD>
		<td><font face=\"arial, helvetica\">"._("ID:")." $id</font></td>\n";
  	PRINT "<td><font face=\"arial, helvetica\">"._("Group Name:")
		."<br><input type=text size=\"65%\"
		name=groupname value=\"$groupname\">";
  	PRINT "</font></td>\n</tr>\n";

  	PRINT "<tr bgcolor=#CCCCCC><td valign=center><input type=hidden 
		name=id value=\"$id\"><input type=submit 
		value="._("Update")."></form></td><td valign=center>";
	PRINT '<form method=get action="'.Config::AbsLoc('users/setup-groups-del.php').'">';
	PRINT "<input type=hidden name=id value=\"$id\">
		<input type=hidden name=groupname value=\"$groupname\">
		<input type=submit value="._("Delete").">&nbsp;&nbsp;";
	PRINT '<a href="'.Config::AbsLoc("users/setup-groups-members.php?id=$id").'">'
		._("Edit Group Members").'</a></form></td></tr></table>';
  	PRINT "<br>";
}
PRINT "<a name=\"add\"></a><hr noshade><h4>"._("Add a Group")."</h4>";
PRINT '<form method=post action="'.Config::AbsLoc('users/setup-groups-add.php').'">';
PRINT '<table width=100% border=1 noshade bordercolor=#000000>
	<tr bgcolor=#CCCCCC>
	<td colspan=2><strong>'._("New Group").'</strong></td></tr>';
PRINT "<tr bgcolor=#DDDDDD> <td><font face=\"arial, helvetica\">"._("Name:")."<br> 
		<input type=text size=\"65%\" name=groupname></td></tr>";
PRINT "<tr bgcolor=#CCCCCC><td colspan=2><input type=submit value="._("Add").">
		</td></tr></table></form>";

commonFooter();
