/*
  ImageMagick private image colorspace methods.
*/
#ifndef _MAGICK_COLORSPACE_PRIVATE_H
#define _MAGICK_COLORSPACE_PRIVATE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

static inline void RGBtoCMYK(MagickPixelPacket *pixel)
{
  MagickRealType
    black,
    cyan,
    magenta,
    yellow;
                                                                                
  cyan=MaxRGB-pixel->red;
  magenta=MaxRGB-pixel->green;
  yellow=MaxRGB-pixel->blue;
  black=cyan < magenta ? Min(cyan,yellow) : Min(magenta,yellow);
  pixel->colorspace=CMYKColorspace;
  pixel->red=cyan;
  pixel->green=magenta;
  pixel->blue=yellow;
  pixel->index=black;
}

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
