<?php
// File           jsrs/systable_request.php / ibWebAdmin
// Purpose        deliver the html for a system table
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <03/08/22 22:22:43 lb>
//
// $Id: systable_request.php,v 1.4 2004/03/28 11:29:00 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');
require('../inc/functions.inc.php');
require('../inc/system_table.inc.php');
require('../inc/interbase.inc.php');
require('./jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

session_start();
localize_session_vars();

$dbhandle = db_connect();

jsrsDispatch('systable');


// build the answer for the jsrs requests
function systable($seconds){
    global $s_systable, $s_login;

    list($family, $version) = server_info($s_login['server']);
    define('SERVER_FAMILY', $family);
    define('SERVER_VERSION', $version);
    $s_systable['refresh'] = $seconds;

    if ($seconds != 0) {
        $systable = get_systable($s_systable);
        $html = get_systable_html($systable, $s_systable);
    }
    else {
        $html = '';
    }

    globalize_session_vars();

    return jsrsArrayToString(array($html), $delim='~');
}

?>
