/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: CpuLoadWidget.h,v 1.8 2004/05/03 14:02:19 comix Exp $
 *
 */


#ifndef CPU_LOAD_WIDGET_H
#define CPU_LOAD_WIDGET_H

#include <string>
#include <iostream>

#include "config.h"
#include "qwidget.h"
#include "qpixmap.h"
#include "qpainter.h"
#include "qtimer.h"

#include "lib/EngineListener.h"
#include "Object.h"

///
/// Shows CPU load
///
class CpuLoadWidget : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		CpuLoadWidget(QWidget * parent, const char * name = 0);
		~CpuLoadWidget();

		void setValue(uint newValue);
		uint getValue();

		void mousePressEvent(QMouseEvent *ev);
		void paintEvent(QPaintEvent *ev);

		void xRunEvent(float nTime, float nMaxTime);
		void customEvent( QCustomEvent *ev );


	public slots:
		void updateCpuLoadWidget();

	private:
		uint m_nValue;
		uint m_nXRunValue;

		static const uint WIDTH = 110;
		static const uint HEIGHT = 20;

		QPixmap m_temp;
		QPixmap m_back;
		QPixmap m_leds;

		bool m_bChanged;
};


#endif
