#ifndef _HXLIB_H
#define _HXLIB_H 1

#include "hx_types.h"

extern char const *hx_version_string;

extern void hx_loop (void) __attribute__((__noreturn__));
extern void hx_set (void (*fun)(void), u_int32_t len);
extern void hx_reset (void);
extern void hx_exit (int) __attribute__((__noreturn__));
extern int hx_conn_open (const char *node, u_int16_t port);
extern void hx_conn_close (void);
struct input;
extern void hx_input_fun (struct input *ip);

extern int hx_sock;
extern u_int8_t *hx_buf;
extern u_int32_t hx_pos, hx_len, hx_trans;
extern void (*hx_fun)(void);

struct privchat {
	struct privchat *next;
	u_int32_t ref, trans;
	struct user *user_list;
	char slen, subject[256];
};

extern struct privchat *curchat;

extern void privchat_kill (void);

struct user {
	struct user *next;
	u_int32_t sock;
	u_int16_t icon,
		  colour;
	u_int8_t nlen, nick[32];
};

extern struct user *user_list;

extern struct user *user_new (struct user **ulp);
extern struct user *user_lookup_sock (struct user *ulist, u_int32_t sock);
extern void user_print (struct user *ulist);
extern void user_print_search (struct user *ulist, const char *str);
extern void user_kill (struct user **ulp);
extern u_int32_t sock_lookup_nick (const char *nick, u_int8_t nlen);

typedef void (*task_fn_t)(void *);

struct task {
	struct task *next;
	u_int32_t trans;
	task_fn_t fun, errfun;
	void *data;
};

extern struct task *task_list;

extern void task_new (u_int32_t trans, task_fn_t fun, task_fn_t errfun, void *data);
#define TASK_NEW(trans, fun, errfun, data) \
	task_new(trans, (task_fn_t)fun, (task_fn_t)errfun, (void *)data)

extern void news_kill (void);

extern void rcv_chat (void);
extern void rcv_msg (void);
extern void rcv_user_list (void *ulist_ptr);
extern void rcv_user_change (void);
extern void rcv_user_leave (void);
extern void rcv_task (void);
extern void rcv_news_file (void *do_cmd_news);
extern void rcv_news_post (void);
extern void rcv_chat_user_list (struct privchat *pc);
extern void rcv_chat_invite (void);
extern void rcv_chat_user_change (void);
extern void rcv_chat_user_leave (void);
extern void rcv_chat_subject (void);

struct hx_preferences {
	u_int16_t icon;
	char nick[32];
};

extern struct hx_preferences hx_prefs;

extern void strexpand (char *p);

#define atou32(_str) ((u_int32_t)strtoul(_str, 0, 0))
#define atou16(_str) ((u_int16_t)strtoul(_str, 0, 0))

#define CR2LF(_ptr, _len) \
{ register unsigned int _i;\
	for (_i = 0; _i < (unsigned)_len; _i++) {\
		if (_ptr[_i] == '\r')\
			_ptr[_i] = '\n';\
		else if (_ptr[_i] == 14)\
			_ptr[_i] = 'N';\
		else if (_ptr[_i] == '\010')\
			_ptr[_i] = 'b';\
	}\
}

extern void colourz (char *);
extern void expand_tilde (char *, char *);

#endif /* !_HXLIB_H */
