/*
 * inet.c -- inet stuff
 * hotwayd is a POP3-HTTPMail gateway. It will allow you to
 * check your HOTMAIL account from your unix box.
 * Created: Espeleta Tomas <espeleta@libero.it>, 12-Apr-2001
 * This code is taken from on nupop-0.4, by Kevin Stone <kstone@nuvox.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>

#include "hotwayd.h"
#include "inet.h"

char inet_server_name[N_BUFLEN] = "noname";
char inet_server_domain[N_BUFLEN] = "\0";
char inet_client_name[N_BUFLEN] = "0.0.0.0";
char inet_server_addr[N_BUFLEN] = "0.0.0.0";

void inet_init(void) {
	struct sockaddr_in sock;
	int	slen = sizeof(struct sockaddr);	

	/* get hostname of this machine as servername */
	gethostname(inet_server_name, N_BUFLEN - 1);
	inet_server_name[N_BUFLEN - 1] = '\0';

	/* get ip addr of server (inet_server_addr) */
	if (getsockname(0, (struct sockaddr *) &sock, &slen) == 0) {

		strncpy(inet_server_addr, inet_ntoa(sock.sin_addr), N_BUFLEN - 1);
		inet_server_addr[N_BUFLEN - 1] = '\0';
		
#ifdef USE_DNS
	  {
		struct hostent *hostent;
		/* get reverse of the port the client connected to (inet_server_name) */
		hostent = gethostbyaddr((char *)&sock.sin_addr, sizeof (sock.sin_addr), AF_INET);
	    if (hostent != NULL) {
			strncpy(inet_server_name, hostent->h_name, N_BUFLEN - 1);
			inet_server_name[N_BUFLEN - 1] = '\0';
		}
	  }
#endif
	}	

	/* get addr of client (we're not doing reverses) - inet_client_name */
	if (getpeername(0, (struct sockaddr *) &sock, &slen) == 0) {

		strncpy(inet_client_name, inet_ntoa(sock.sin_addr), N_BUFLEN - 1);
		inet_client_name[N_BUFLEN - 1] = '\0';
	}
			
	DPRINTF("Got server name/addr: %s/%s\n", inet_server_name, inet_server_addr);
	DPRINTF("Got client name: %s\n", inet_client_name);
}		




	
