// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_font.h"
hk_string hk_font::p_defaultfont="Courier";
int hk_font::p_defaultfontsize=12;

hk_font::hk_font()
{

set_font(p_defaultfont,p_defaultfontsize);
p_bold=false;
p_italic=false;
}


hk_font::hk_font(const hk_string& fname,int fsize)
{
 set_font(fname,fsize);

}

hk_font::hk_font(const hk_font& f)
{
  *this=f;

}


void hk_font::set_font(const hk_string& fname,int fsize)
{
 p_fontname=trim(fname);
 p_fontsize=fsize;

}




void hk_font::set_font(const hk_font& f)
{
  p_fontname=f.p_fontname;
  p_fontsize=f.p_fontsize;
  p_bold=f.p_bold;
  p_italic=f.p_italic;


}


hk_string hk_font::fontname(void) const
{
 return p_fontname;

}

int hk_font::fontsize(void) const
{
return p_fontsize;

}

void hk_font::savedata(ostream& s )
{
    start_mastertag(s,"HK_FONT");
    set_tagvalue(s,"FONT",p_fontname);
    set_tagvalue(s,"FONTSIZE",p_fontsize);
    set_tagvalue(s,"BOLD",p_bold);
    set_tagvalue(s,"ITALIC",p_italic);
    end_mastertag(s,"HK_FONT");



}

void hk_font::loaddata(const hk_string& definition)
{
    get_tagvalue(definition,"FONT",p_fontname);
    get_tagvalue(definition,"FONTSIZE",p_fontsize);
    get_tagvalue(definition,"BOLD",p_bold);
    get_tagvalue(definition,"ITALIC",p_italic);


}


bool hk_font::operator=(const hk_font& f)
{
  set_font(f);

 return true;
}

bool hk_font::operator==(const hk_font& f)
{
    return is_equal(f);
}


bool hk_font::operator!=(const hk_font& f)
{
    return !is_equal(f);
}

bool hk_font::is_equal(const hk_font&f)
{
return (p_fontname==f.p_fontname &&  p_fontsize==f.p_fontsize);

}


void hk_font::set_defaultfont(const hk_string& d, int s)
{
    p_defaultfont=d;
    p_defaultfontsize=s;

}


hk_string hk_font::defaultfontname(void)
{
    return p_defaultfont;

}


int hk_font::defaultfontsize(void)
{
    return p_defaultfontsize;
}


void hk_font::set_bold(bool b)
{
  p_bold=b;

}

bool hk_font::bold(void) const
{
  return p_bold;
}


void hk_font::set_italic(bool i)
{
  p_italic=i;
}

bool hk_font::italic(void) const
{
  return p_italic;
}



hk_string hk_font::psfontname(void)const
{
const hk_string obliques= "avantgarde courier helvetica";
 bool useoblique=(obliques.find(string2lower(p_fontname))!=hk_string::npos);
    hk_string psfont=p_fontname;
    if (p_bold || p_italic) psfont+="-";
    if (p_bold) psfont+="Bold";
    if (p_italic) psfont+=useoblique?"Oblique":"Italic";

  
  return psfont;
}






ostream& operator<<(ostream&    stream   ,hk_font& c)
{
    stream <<"("<<hk_class::hk_translate("font: ")<<c.fontname()<<"("<<c.fontsize()<<")";
    return stream;
}


ostream& operator<<(ostream&    stream   ,const hk_font& c)
{
    stream <<"("<<hk_class::hk_translate("font: ")<<c.fontname()<<"("<<c.fontsize()<<")";
    return stream;
}


