/*
   Hanja handling routine
   written by Yang, Woosuk.
   3. 10. 1994.
 */
#ifdef HAVE_CONFIG_H
#include <xtermcfg.h>
#endif
#include "ptyx.h"
#include "data.h"
#include "error.h"
#include <X11/keysym.h>
#include "xterm.h"
#include "hangul.h"
#include "hanja.h"
#include <stdio.h>

static void put_hanja PROTO((int item));

/*
   Է : ѱ ڵ (int han_code)
    :  ̺ (int hanja_code_table[] : ĪǴ ڵ.)
   ϰ : Ī .
 */
int hanja_mode = 0;

static int get_hanja_codes(han_code, hanja_code_table)
unsigned int han_code, hanja_code_table[];
{
    unsigned int j;
    int i, k, count;

    for (i = 0; i < MAX_HANJA_TABLE; i++) {
	if (han_code == hanja_table[i][0]) {
	    count = hanja_table[i + 1][1] - hanja_table[i][1];
	    if (count > 0x80) {	/* gap exist */
		count -= 0xa2;
	    }
	    for (j = hanja_table[i][1], k = 0; k < count; j++, k++) {
		if ((j & 0x00ff) > 0xfe)
		    j += 0xa2;
		hanja_code_table[k] = j;
	    }
	    return count;
	}
    }
    return 0;
}

#define MAXHANJABUF 200

static int hanja_sx, hanja_count, hanja_max_item, hanja_max_disp;

unsigned int hanja_codes[MAXHANJABUF];

void toggle_hanja_mode(han_code)
unsigned int han_code;
{
    int count = 0;

    if (!hanja_mode)
	if ((count = get_hanja_codes(han_code, hanja_codes)) == 0)
	    hanja_mode = 1;
    hanja_mode ^= 1;
    if (hanja_mode) {
	hanja_count = count;
	hanja_sx = 0;
	hanja_max_disp = 0;
	show_hanja_buf();
    } else {
	chat_clear_line(length_of_statusline(),
		      term->screen.max_col - length_of_statusline() + 1);
    }
}

void show_hanja_buf()
{
    TScreen *screen = &term->screen;
    Char hanja_line[200];
    char tmp[200];
    int i;

    sprintf((char *) hanja_line, "[%2d/%2d]", hanja_sx + 1, hanja_count);
    for (i = 0; i < 9; i++) {
	if ((int) strlen((char *) hanja_line) + length_of_statusline() > term->screen.max_col - 6)
	    break;
	if (i + hanja_sx >= hanja_count)
	    break;
	sprintf(tmp, " %d. %c%c", i + 1, (Char) (hanja_codes[i + hanja_sx] / 0x100),
		(Char) (hanja_codes[i + hanja_sx] % 0x100));
	strcat((char *) hanja_line, (char *) tmp);
    }

    hanja_max_item = i;
    if (i + hanja_sx < hanja_count)
	hanja_max_disp = i;
    else if (i > hanja_max_disp)
	hanja_max_disp = i;

    for (i = strlen((char *) hanja_line); i <= term->screen.max_col - length_of_statusline(); i++) {
	hanja_line[i] = ' ';
    }
    hanja_line[i] = '\0';
    if (screen->code == C_WANSUNG) {
	for (i = 0; i <= strlen((char *) hanja_line); i++)
	    tmp[i] = ((char *) hanja_line)[i];
    } else {
	convert_ks_to_johab(hanja_line, tmp, strlen((char *) hanja_line));
    }

    HDrawImageString(screen->display, TextWindow(screen), NormalGC(screen),
		     NormalHGC(screen),
		     CursorX(screen, length_of_statusline()),
		     (screen->max_row + 1) * FontHeight(screen) +
		     screen->ascent + screen->border * 2,
		     tmp,
		     strlen(tmp));
}

void hanja_mode_input(keysym, event, string, nbytes)
KeySym keysym;
XKeyEvent *event;
Char *string;
int nbytes;
{
    int sel;

    if (keysym == XK_Escape) {
	toggle_hanja_mode(0);
    } else if (keysym == XK_space) {
	hanja_sx += hanja_max_disp;
	if (hanja_sx >= hanja_count)
	    hanja_sx = 0;
	show_hanja_buf();
    } else if (IsCursorKey(keysym)) {
	switch (keysym) {
	case XK_Left:
	    hanja_sx -= hanja_max_disp;
	    if (hanja_sx < 0)
		hanja_sx = 0;
	    show_hanja_buf();
	    break;
	case XK_Right:
	    hanja_sx += hanja_max_disp;
	    if (hanja_sx >= hanja_count)
		hanja_sx = 0;
	    show_hanja_buf();
	    break;
	case XK_Home:
	    hanja_sx = 0;
	    show_hanja_buf();
	    break;
	}
    } else if (nbytes > 0) {
	if (*string > '0' && *string <= '9') {
	    sel = *string - '1';
	    if (sel < hanja_max_item) {
		put_hanja(hanja_sx + sel);
		toggle_hanja_mode(0);
	    }
	}
    }
}

static void put_hanja(item)
int item;
{
    Char code[2];

    code[0] = hanja_codes[item] / 0x100;
    code[1] = hanja_codes[item] % 0x100;
    HideCursor();
    if (term->screen.code == C_JOHAB)
	convert_ks_to_johab(code, temp_hangul, 2);
    else {
	temp_hangul[0] = code[0];
	temp_hangul[1] = code[1];
    }


    ShowCursor();
    v_write(term->screen.respond, temp_hangul, 2);
    HideCursor();
    automata_clear();
    hangul_state = 1;
    ShowCursor();
}
