//
// $Id: if.h,v 1.1.1.1 2000/11/29 13:20:38 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/if.h,v $
// $Revision: 1.1.1.1 $
// $Date: 2000/11/29 13:20:38 $
// $State: Exp $
//
// Author: Geoff Wong / Mick Dwyer, 1999
//

#ifndef _IF_H
#define _IF_H

#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#ifndef Linux
# include <sys/sockio.h>
#endif

#ifdef FreeBSD
# include <net/if_dl.h>
#endif

#include "config.h"


#define MIN_IFS 4
#define MAX_IFS 8196

class If
{
    long _ipaddr;
    struct ifreq * altif;

public:
    char * Ifconf(int sfd, int * name);
    // get all interfaces into a char * buffer

    struct ifreq * Ifreq();
    // return the ifreq for this interface

    void Ifget(long ipaddr);
    // Given an IP address; check it's a valid interface and
    // set up this class

    long Ipaddr();
    // return the long IP addr

    If();
    If(long);
    // constructors ..
        
    virtual ~If();
};

#endif
