/* some Drag and Drop support functions */

#include <gtk/gtk.h>
#include <stdlib.h>

#include "main.h"
#include "dndsetup.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

int dndsetup_dragtype=0;

enum 
{
	TARGET_STRING,TARGET_PLAINTEXT,TARGET_URI_LIST
};

static GtkTargetEntry target_table[] = 
{
	  { "STRING"    , 0, TARGET_STRING},
	  { "text/plain", 0, TARGET_PLAINTEXT },
	  { "text/uri-list",0,TARGET_URI_LIST },
	  { "FILE_NAME",0,TARGET_URI_LIST },   
	  { "FILENAME",0,TARGET_URI_LIST },
	  { "FILE_NAME",0,TARGET_URI_LIST },
   	  { "text/plain;charset=UTF-8",0,TARGET_STRING }
};

static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);

void dndsetup_setaction (GtkWidget *w,
			 GdkEventButton *event,
			 gpointer data)
{
   if (event->button==1)
     dndsetup_dragtype=DNDSETUP_LINK;
   if (event->button==3)
     dndsetup_dragtype=DNDSETUP_COPY;
};

void dndsetup_dragged(GtkWidget *w,
		      GdkDragContext *ct,
		      GtkSelectionData *data,
		      guint inf,
		      guint time,
		      dndsetup_info *info)
{
   char *dragdata;
   /* get data from highlevel handler */
   dragdata=info->dragcb(info->userdata);
   gtk_selection_data_set (data,
			   data->target,
			   8,
			   dragdata,
			   strlen(dragdata));
}
;

void dndsetup_dragdone(GtkWidget *w,
		       GdkDragContext *c,
		       dndsetup_info *info)
{
   if (info->donecb!=NULL)
     info->donecb(dndsetup_dragtype,info->userdata);
   /* reset internal drop state */
   dndsetup_dragtype=0;
}
;

void dndsetup_dropped(GtkWidget *w,
		      GdkDragContext *c,
		      gint x,
		      gint y,
		      GtkSelectionData *data,
		      guint inf,
		      guint time,
		      dndsetup_info *info)
{
   int success=0;
   
#ifdef DEBUG
   printf ("dndsetup_dropped: got drop event: ");
   if (dndsetup_dragtype==DNDSETUP_LINK)
     printf ("link object.\n");
   if (dndsetup_dragtype==DNDSETUP_COPY)
     printf ("copy object.\n");
#endif
   if ((data->length>=0) && (data->format == 8)
       && (info->dropcb!=NULL))
     {
	char *converted_data=helpings_convertspecialchars((char*)data->data); /* data line with %xx already replaced by their respective characters */
	success=info->dropcb(converted_data,
			     x,y,
			     dndsetup_dragtype,
			     info->userdata);
	free(converted_data);
     }
   ;
   gtk_drag_finish (c,success,FALSE,time);
}
;

void dndsetup_drag(GtkWidget *w,
                   dndsetup_dragcallback dragcb,
		   dndsetup_dragdonecallback donecb,
		   void *data)
{
   dndsetup_info *info;

   /* FIXME: this never gets freed,we'd need some kind of uninstall
    * dnd handler functionality taking a pointer to the info structure
    * as argument for that */
   info=(dndsetup_info*)malloc(sizeof(dndsetup_info));
   /* fill out the info structure */
   info->userdata=data;
   info->dragcb=dragcb;
   info->donecb=donecb;
   /* if dragged with left mouse button *link* only,
    * if dragged with right mouse button *copy*.
    * "copying" a track means precaching.
    * "linking" a track should be clear enough.
    * "linking" a file means adding a new filesource to the virtual fs,
    * "copying" means actually making a copy of the file in some protected
    * area,so's the medium containing the original file can be 
    * removed safely */
   gtk_drag_source_set (w,
			GDK_BUTTON1_MASK|GDK_BUTTON3_MASK,
			target_table, n_targets,
			GDK_ACTION_LINK|GDK_ACTION_COPY);
   if (dragcb!=NULL)
     gtk_signal_connect (GTK_OBJECT(w), "drag_data_get",
			 dndsetup_dragged,info);
   gtk_signal_connect (GTK_OBJECT(w), "drag_end",
		       dndsetup_dragdone,info);
   gtk_signal_connect(GTK_OBJECT(w),"button_press_event",
		      dndsetup_setaction,NULL);
}
;

/* setup a raw dnd drop destination */
void dndsetup_drop_raw(GtkWidget *w,
		       GtkSignalFunc drophandler,
		       gpointer data)
{
   gtk_drag_dest_set (w,
		      GTK_DEST_DEFAULT_MOTION|GTK_DEST_DEFAULT_DROP,
		      target_table,n_targets,
		      GDK_ACTION_COPY | GDK_ACTION_LINK | GDK_ACTION_MOVE );
   gtk_signal_connect (GTK_OBJECT(w), "drag_data_received",
		       drophandler,data);
};
   
void dndsetup_drop(GtkWidget *w,
		   dndsetup_dropcallback dropcb,
		   void *data)
{
   dndsetup_info *info;

   /* FIXME: this never gets freed,we'd need some kind of uninstall
    * dnd handler functionality taking a pointer to the info structure
    * as argument for that */
   info=(dndsetup_info*)malloc(sizeof(dndsetup_info));
   /* fill out the info structure */
   info->userdata=data;
   info->dropcb=dropcb;
   dndsetup_drop_raw(w,dndsetup_dropped,info);
}
;
