// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_LISTSTORE_H
#define _GTKMM_LISTSTORE_H

#include <glibmm.h>

/* $Id: liststore.hg,v 1.19 2002/12/23 19:09:03 daniel Exp $ */

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treeiter.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treesortable.h>
#include <gtkmm/treedragdest.h>
#include <gtkmm/treedragsource.h>
// We couldn't include it in treemodel.h, but doing it here makes it easier for people.
#include <gtkmm/treepath.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkListStore GtkListStore;
typedef struct _GtkListStoreClass GtkListStoreClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ListStore_Class; } // namespace Gtk
namespace Gtk
{

/** Thist is a list model for use with a Gtk::TreeView widget.
 * @ingroup TreeView
 * It implements the Gtk::TreeModel interface, and also implements the
 * Gtk::TreeSortable interface so you can sort the list using the view.
 * Finally, it also implements the tree drag and drop interfaces.
 */

class ListStore :
  public Glib::Object,
  public TreeModel,
  public TreeSortable,
  public TreeDragSource,
  public TreeDragDest
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ListStore CppObjectType;
  typedef ListStore_Class CppClassType;
  typedef GtkListStore BaseObjectType;
  typedef GtkListStoreClass BaseClassType;

private:  friend class ListStore_Class;
  static CppClassType liststore_class_;

private:
  // noncopyable
  ListStore(const ListStore&);
  ListStore& operator=(const ListStore&);

protected:
  explicit ListStore(const Glib::ConstructParams& construct_params);
  explicit ListStore(GtkListStore* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ListStore();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkListStore*       gobj()       { return reinterpret_cast<GtkListStore*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkListStore* gobj() const { return reinterpret_cast<GtkListStore*>(gobject_); }

  GtkListStore* gobj_copy();

private:

  
protected:
  explicit ListStore(const TreeModelColumnRecord& columns);

public:
  
  static Glib::RefPtr<ListStore> create(const TreeModelColumnRecord& columns);


  iterator erase(const iterator& iter);
  iterator insert(const iterator& iter);

  iterator prepend();
  iterator append();

  
  /** Swaps @a a  and @a b  in @a store . Note that this function only works with
   * unsorted stores.
   * 
   * Since: 2.2
   * @param a A Gtk::TreeIter.
   * @param b Another Gtk::TreeIter.
   */
  void iter_swap(const iterator& a, const iterator& b);

  /** Moves @a source to the position at @a destination.
   * Note that this function only works with unsorted stores.
   * @param source The row that should be moved.
   * @param destination The position to move to.
   */
  void move(const iterator& source, const iterator& destination);

  /** Reorders the list store to follow the order indicated by @a new_order.
   * Note that this function only works with unsorted stores.
   */
  void reorder(const Glib::ArrayHandle<int>& new_order);

  
  /** Removes all rows from the list store.
   */
  void clear();

  
  /** WARNING: This function is slow. Only use it for debugging and/or testing
   * purposes.
   * 
   * Checks if the given iter is a valid iter for this Gtk::ListStore.
   * @param iter A Gtk::TreeIter.
   * @return <tt>true</tt> if the iter is valid, <tt>false</tt> if the iter is invalid.
   * 
   * Since: 2.2.
   */
  bool iter_is_valid(const iterator& iter) const;

protected:
  virtual void set_value_impl(const iterator& row, int column, const Glib::ValueBase& value);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::ListStore */
  Glib::RefPtr<Gtk::ListStore> wrap(GtkListStore* object, bool take_copy = false);
}


#endif /* _GTKMM_LISTSTORE_H */

