# $Id: ServerList.pm,v 1.2 2003/02/01 17:26:10 jodrell Exp $
package Greenwich::ServerList;

use strict;

sub new {
	my $self		= {};
	my ($PACKAGE, %args)	= @_;
	$self->{lexicon}	= $args{lexicon};
	$self->{app}		= $args{app};
	$self->{PACKAGE}	= $PACKAGE;
	bless($self, $self->{PACKAGE});
	$self->{window} = Gtk::Dialog->new();
	$self->{window}->set_usize(300, 300);
	$self->{window}->set_title($self->string('serverlist'));
	$self->{window}->signal_connect('destroy', sub { $self->destroy() });

	$self->{buttons}{ok_button} = Gnome::Stock->button('Button_Ok');

	$self->{buttons}{cancel_button} = Gnome::Stock->button('Button_Cancel');
	$self->{buttons}{cancel_button}->signal_connect('clicked', sub { $self->destroy() });

	$self->{list} = Gtk::CList->new_with_titles($self->string('yourservers'));
	$self->{list}->set_selection_mode('single');
	$self->{list}->column_titles_passive();
	$self->{list}->signal_connect('select_row',   sub { $self->{selected_index} = $_[1] });
	$self->{list}->signal_connect('unselect_row', sub { $self->{selected_index} = undef });

	$self->{list}->signal_connect('select_row', sub {}); # @_[1] is the selected row 

	$self->{scrolled_window} = Gtk::ScrolledWindow->new(undef, undef);
	$self->{scrolled_window}->set_policy('automatic', 'automatic');
	$self->{scrolled_window}->add($self->{list});

	$self->{button_box} = Gtk::HBox->new(0, 0);

	$self->{buttons}{add_button} = Gnome::Stock->gnome_pixmap_button(Gnome::Stock->new_with_icon('Add'), $self->string('addserver'));
	$self->{buttons}{add_button}->signal_connect(
		'clicked',
		sub {
			my $addWin = Gtk::Dialog->new();
			$addWin->set_position('center');
			$addWin->set_title($self->string('addserver'));
			my $okButton = Gnome::Stock->button('Button_Ok');
			my $serverName = Gtk::Entry->new();
			$serverName->set_usize(30, 0);
			$serverName->signal_connect(
				'activate',
				sub {
					my $server = $serverName->get_text();
					push(@{$self->{servers}}, $server);
					$self->update_list();
					$addWin->destroy();
				}
			);
			$addWin->vbox()->pack_start(Gtk::Label->new($self->string('entername')), 0, 0, 0);
			$addWin->vbox()->pack_start($serverName, 0, 0, 0);
			$okButton->signal_connect(
				'clicked',
				sub {
					my $server = $serverName->get_text();
					push(@{$self->{servers}}, $server);
					$self->update_list();
					$addWin->destroy();
				}
			);
			my $cancelButton = Gnome::Stock->button('Button_Cancel');
			$cancelButton->signal_connect('clicked', sub { $addWin->destroy() });
			$addWin->vbox()->set_border_width(8);
			$addWin->vbox()->set_spacing(8);
			$addWin->action_area()->set_border_width(0);
			$addWin->action_area()->pack_start($okButton, 1, 1, 0);
			$addWin->action_area()->pack_start($cancelButton, 1, 1, 0);
			$addWin->show_all();
			$serverName->grab_focus();
		}
	);
	$self->{buttons}{del_button} = Gnome::Stock->gnome_pixmap_button(Gnome::Stock->new_with_icon('Remove'), $self->string('deleteserver'));
	$self->{buttons}{del_button}->signal_connect(
		'clicked',
		sub {
			if ($self->{selected_index} ne '') {
				my @servers = $self->servers();
				undef $servers[$self->{selected_index}];
				$self->set_servers(@servers);
				undef $self->{selected_index};
			}
		}
	);

	$self->{window}->action_area()->border_width(0);
	$self->{window}->vbox()->border_width(8);
	$self->{window}->vbox()->set_spacing(8);
	$self->{button_box}->set_spacing(8);

	$self->{button_box}->pack_start($self->{buttons}{add_button},	1, 1, 0);
	$self->{button_box}->pack_start($self->{buttons}{del_button},	1, 1, 0);

	$self->{window}->vbox()->pack_start($self->{scrolled_window}, 1, 1, 0);
	$self->{window}->vbox()->pack_start($self->{button_box}, 0, 0, 0);

	$self->{window}->action_area()->pack_start($self->{buttons}{ok_button},		1, 1, 0);
	$self->{window}->action_area()->pack_start($self->{buttons}{cancel_button},	1, 1, 0);

	return $self;
}

sub set_servers {
	my $self = shift;
	my @servers = @_;
	$self->{servers} = \@servers;
	$self->update_list();
	return;
}

sub update_list {
	my $self = shift;
	$self->{list}->freeze();
	$self->{list}->clear();
	foreach my $server(@{$self->{servers}}) {
		$self->{list}->append(($server)) if (defined($server));
	}
	$self->{list}->thaw();
	return;
}

sub servers {
	my $self = shift;
	return grep { defined } @{$self->{servers}};
}

sub string {
	my ($self, $str) = @_;
	return $self->{lexicon}->maketext($str);
}

sub show {
	my $self = shift;
	$self->{window}->show_all();
	$self->{buttons}{ok_button}->grab_focus();
	return;
}

sub ok_button {
	my $self = shift;
	return $self->{buttons}{ok_button};
}

sub destroy {
	my $self = shift;
	$self->{window}->destroy();
}

1;