/* callbacks.c
 * Contains functions which are executed when users interact with
 * the GUI elements. 
 */

/* (c) 1998-2000 by Keith Wesolowski (wesolows@foobazco.org)

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <string.h>
#include <stdlib.h>
#include "gradio.h"
#include "logo.h"

extern radio_status gr_stat;

gint gradio_delete_event_cb (GtkWidget *w, gpointer *data)
{
    return FALSE;
}

void gradio_destroy_cb (GtkWidget *w, gpointer *data) 
{
    gradio_save_rcfile ();
    gtk_main_quit();
}

void gradio_vol_cb (GtkWidget *w, gpointer *data)
{
    int dir = (strcmp ((char*) data, "up") == 0) ? GR_VOL_UP : GR_VOL_DOWN;
    
    if (gr_stat.power == TRUE) {
	gradio_setvol ((dir == GR_VOL_UP) ? (gr_stat.vol+1) : (gr_stat.vol-1));
	gradio_set_display_from_status ();
    }
}

void gradio_tuner_cb (GtkWidget *w, GdkEventButton *data) 
{ 
    int dir = (strcmp (gtk_widget_get_name (w), "tuner_up") == 0) ? GR_TUNER_UP
	: GR_TUNER_DOWN;
    int step = (data->button == 1) ? GR_TUNER_STEP_LARGE : GR_TUNER_STEP_SMALL;

    if (gr_stat.power == TRUE && data->type == GDK_BUTTON_PRESS) {
	gradio_setfreq ((dir == GR_TUNER_UP) ? (gr_stat.freq+step) 
			: (gr_stat.freq-step));
	gr_stat.memset = -1;
	gradio_set_display_from_status ();
    }
}

void gradio_power_cb (GtkWidget *w, gpointer *data) 
{ 
    static int temp;
    if (gr_stat.power == TRUE) {
	temp = gr_stat.muted;
	gradio_mute (TRUE);
	gr_stat.muted = temp;
	gr_stat.power = FALSE;
    } else {
	gradio_mute (temp);
	gr_stat.power = TRUE;
    }
    gradio_set_display_from_status ();
}

void gradio_mute_cb (GtkWidget *w, gpointer *data) 
{ 
    if (gr_stat.power == TRUE) {
	if (gr_stat.muted == TRUE)
	    gradio_mute (FALSE);
	else
	    gradio_mute (TRUE);
	gradio_set_display_from_status ();
    }
}

void gradio_memory_cb (GtkWidget *w, GdkEventButton *data) 
{ 
    int mem_button = atoi (gtk_widget_get_name (w) + 4) - 1;
    
    if (gr_stat.power == TRUE) {
	if (data->button == 1) {
	    gradio_setfreq (gr_stat.mem[mem_button]);
	    gr_stat.memset = mem_button+1;
	}
	else {
	    gr_stat.memset = mem_button+1;
	    gr_stat.mem[mem_button] = gr_stat.freq;
	}
	gradio_set_display_from_status ();
    }
}

gint gradio_button_press_cb (GtkWidget *w, GdkEvent *data)
{
    if (data->type == GDK_BUTTON_PRESS) {
	GdkEventButton *bevent = (GdkEventButton *) data;
	gtk_menu_popup (GTK_MENU(w), NULL, NULL, NULL, NULL,
			bevent->button, bevent->time);
	return TRUE;
    }
     
    return FALSE;
}  

void gradio_setfreq_cb (GtkWidget *w, gpointer *data)
{
    GtkWidget *dialog_box;
    GtkWidget *label;
    GtkWidget *text;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    GtkWidget *hbox;

    dialog_box = gtk_dialog_new ();
    label = gtk_label_new ("Set to frequency");
    gtk_widget_show (label);
    text = gtk_entry_new_with_max_length (7);
    ok_button = gtk_button_new_with_label ("OK");
    cancel_button = gtk_button_new_with_label ("Cancel");
    gtk_signal_connect (GTK_OBJECT (ok_button), "clicked", 
			GTK_SIGNAL_FUNC (gradio_freq_from_value_cb), 
			(gpointer) text);
    gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			GTK_SIGNAL_FUNC (gradio_close_dialog_cb), 
			(gpointer) dialog_box);
    gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked", 
			GTK_SIGNAL_FUNC (gradio_close_dialog_cb), 
			(gpointer) dialog_box);
    gtk_widget_show (ok_button);
    gtk_widget_show (cancel_button);
    gtk_signal_connect (GTK_OBJECT (text), "activate", 
			GTK_SIGNAL_FUNC (gradio_freq_from_value_cb), 
			(gpointer) text);
    gtk_signal_connect (GTK_OBJECT (text), "activate",
			GTK_SIGNAL_FUNC (gradio_close_dialog_cb), 
			(gpointer) dialog_box);
    gtk_widget_show (text);
    hbox = gtk_hbox_new (FALSE, 4);
    gtk_box_pack_start (GTK_BOX (hbox), text, TRUE, FALSE, 4);
    gtk_widget_show (hbox);
    gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog_box)->vbox), 4);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_box)->vbox), label, TRUE, 
			TRUE, 4);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_box)->vbox), hbox, FALSE, 
			FALSE, 8);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_box)->action_area), 
			ok_button, TRUE, TRUE, 4);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_box)->action_area), 
			cancel_button, TRUE, TRUE, 4);
    gtk_widget_show (dialog_box);
}

void gradio_help_cb (GtkWidget *w, gpointer *data)
{
    fprintf (stderr, "Help selected\n");
}

void gradio_about_cb (GtkWidget *w, gpointer *data)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *hbox[6];
    GtkWidget *sep;
    GdkPixmap *logo;
    GdkBitmap *mask;
    GtkWidget *logo_gtk;
    GtkWidget *label[5];
    GtkWidget *button;
    GtkStyle *style;
    int i;

    window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_widget_realize (window);
    style = gtk_widget_get_style (window);
    logo = gdk_pixmap_create_from_xpm_d (window->window, &mask, 
					 &style->bg[GTK_STATE_NORMAL], 
					 gr_logo_small_xpm);
    logo_gtk = gtk_pixmap_new (logo, mask);
    gtk_widget_show (logo_gtk);
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), logo_gtk, TRUE, FALSE, 0);
    sep = gtk_hseparator_new ();
    gtk_widget_show (sep);
    gtk_box_pack_start (GTK_BOX (vbox), sep, TRUE, FALSE ,0);
    for (i=0; i<6; i++)
	hbox[i] = gtk_hbox_new (FALSE, 0);
    label[0] = gtk_label_new ("   Author: Keith Wesolowski (wesolows@foobazco.org)   ");
    label[1] = gtk_label_new ("   (c)1998 Keith Wesolowski   ");
    label[2] = gtk_label_new ("   Portions (c)1996 Thomas Lehmann, Gideon LaGrange, and Frans Brinkman.   ");
    label[3] = gtk_label_new ("   This program is distributed under the terms of the GNU General Public License.   ");
    label[4] = gtk_label_new ("   See the file COPYING in this distribution or http://www.fsf.org/copyleft/ for details.   ");
    for (i=0; i<5; i++) {
	gtk_widget_show (label[i]);
	gtk_box_pack_start (GTK_BOX (hbox[i]), label[i], FALSE, FALSE, 0);
	gtk_widget_show (hbox[i]);
	gtk_box_pack_start (GTK_BOX (vbox), hbox[i], FALSE, FALSE, 0);
    }
    button = gtk_button_new_with_label (" That's great! ");
    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
			GTK_SIGNAL_FUNC (gradio_close_dialog_cb), window);
    gtk_widget_show (button);
    gtk_box_pack_start (GTK_BOX (hbox[5]), button, TRUE, FALSE, 0);
    gtk_widget_show (hbox[5]);
    gtk_box_pack_start (GTK_BOX (vbox), hbox[5], TRUE, FALSE, 8);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    gtk_widget_show (window);
}

void gradio_freq_from_value_cb (GtkWidget *w, gpointer *data)
{
    int freq;
    char *value = gtk_entry_get_text ((GtkEntry*)(data)); /* Can't use the macro here */
    if (value == NULL || !(strcmp (value, ""))) return;
    freq = (int)(atof (value) * 1000. + 0.5);
    gradio_setfreq (freq);
    gradio_set_display_from_status ();
}

void gradio_close_dialog_cb (GtkWidget *w, gpointer *data)
{
    gtk_widget_destroy ((GtkWidget*)(data)); /* Here either :) */
}
