#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# config/DataObject.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with configuration files
#
# NOTES and TODO:
#
# @see Connection.py
#

from gnue.common.datasources.drivers.Base.DataObject import DataObject
from ResultSet import Configfile_ResultSet
from gnue.common.apps import GDebug
from gnue.common.datasources import Exceptions
from gnue.common.datasources.drivers import Base
from gnue import paths

class Configfile_DataObject(DataObject):
  # ConditionalName (min args, max args, field creation, bypass function )
  #
  # Commented out conditionals are a bad thing
   
  conditionElements = {
       'add':             (2, 999, None,                    'None'      ),
       'sub':             (2, 999, None,                    'None'      ),
       'mul':             (2, 999, None,                    'None'      ),
       'div':             (2, 999, None,                    'None'      ),
       'and':             (1, 999, '%s',                    '(&%s)'    ),
       'or':              (1, 999, '%s',                    '(|%s)'    ),
       'not':             (1,   1, '(!%s)',                  'None'      ),
       'negate':          (1,   1, '(-%s)',                  'None'      ),
       'eq':              (2,   2, '(%s=%s)',             None     ),
       'ne':              (2,   2, '(%s != %s)',             None     ),
       'gt':              (2,   2, '(%s > %s)',              None     ),
       'ge':              (2,   2, '(%s>=%s)',               None     ),
       'lt':              (2,   2, '(%s < %s)',              None     ),
       'le':              (2,   2, '(%s<=%s)',               None     ),
       'like':            (2,   2, '(%s=%s)',  None     ),
       # there is no LIKE in LDAP
       'notlike':         (2,   2, '(!(%s=%s))',            None     ),
       'between':         (3,   3, '%s BETWEEN %s AND %s',   None     )
       }

  def __init__(self, connection):
    DataObject.__init__(self, connection)

    GDebug.printMesg (9,"Configfile database driver backend initializing")
    self._resultSetClass = Configfile_ResultSet
              
  # never load an empty results                    
  def _createEmptyResultSet(self, readOnly=0, masterRecordSet=None):
    return self.createResultSet(readOnly=readOnly,\
                                conditions=None,\
                                masterRecordSet=masterRecordSet)
  

  def _createResultSet(self, conditions=None, readOnly=0,
                       masterRecordSet=None,sql=""):
    
    if conditions!=None:
      tmsg = _("This database driver always shows all sections\
             of a config file. You cannot execute querys on it.")
      raise Exceptions.ConnectionError, tmsg
    result=[]
    for section in self._dataConnection.sections():
      record={"_section_name":section}
      for option in self._dataConnection.options(section):
         record[option]=self._dataConnection.get(section,option)
         
      result.append(record)
       
    rs = self._resultSetClass(self, cursor=result, masterRecordSet=None)

    rs._readonly = readOnly
    return rs


### The folowing methods are not working
### driver

### TODO add introspection support to geas

  def getSchemaTypes(self):
      return [('object',_('Objects'),1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
      includeObjects = (type in ('object','sources', None))
      
      list = []
      for classname in self._dataConnection.classes:
        list.append(self.getSchemaByName(classname))
      return list

  def getSchemaByName(self, name, type=None): 
      classdef = self._dataConnection.getFullClassDefinition(str(name))
      schema = Base.Schema(attrs={'id':string.lower(classdef.name),
                                  'name':classdef.name,
                                  'type':'object'},
                           getChildSchema=self.__getFieldSchema)
      return schema
  
  # Get fields/methods of a GEAS object
  def __getChildSchema(self, parent):
      list = []
      c = con.getFullClassDefinition( classnames[idx-1] )
      
  def getFields(self, name):
      # no introspection support for now
      return self._fieldReferences.keys()

