/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: snd_buf.h,v 1.8 2002/01/13 02:51:16 dengen Exp $
 *
 */

#ifndef _SND_BUF_H
#define _SND_BUF_H

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include "gnoise.h"

#define WAVE_FORMAT_PCM 1

typedef struct _snd_buf		snd_buf_t;
typedef struct _cue_point	cue_point_t;
typedef struct _cue_chunk	cue_chunk_t;
typedef struct _data_chunk	data_chunk_t;
typedef struct _fmt_chunk	fmt_chunk_t;
typedef struct _list_chunk	list_chunk_t;
typedef struct _wave_header	wave_header_t;
typedef struct _void_chunk	void_chunk_t;

struct _void_chunk
{
    char	chunk_id[4];
    uint	chunk_size;
};

struct _label_chunk
{
    char	chunk_id[4];		/* "labl" */
    uint	chunk_size;
    uint	ident;
    char	text;
};

struct _cue_chunk
{
    char	chunk_id[4];		/* "cue " */
    uint	chunk_size;
    uint	cue_points;
};

struct _cue_point
{
    uint	ident;
    uint	position;
    char	chunk[4];		/* "data" if one data chunk */
    uint	chunk_start;
    uint	block_start;
    uint	sample;
};

struct _list_chunk
{
    char	chunk_id[4];		/* "LIST" */
    uint	chunk_size;
    char	type_id[4];		/* "adtl" */
};

struct _fmt_chunk
{
    char	chunk_id[4];		/* "fmt " */
    int 	chunk_size;
    short	format;
    ushort	channels;
    uint	sample_rate;
    uint	avg_bytes_per_second;
    ushort	block_align;
    ushort	bits_per_sample;    
};

struct _data_chunk
{
    char	chunk_id[4];		/* "data" */
    uint	chunk_size;
};

struct _wave_header
{
    char	group_id[4];		/* "RIFF" */
    uint	size;
    char	riff_type[4];		/* "WAVE" */
    fmt_chunk_t	fmt;
};


struct _snd_buf
{
    char		 file[PATH_MAX];
    int			 fd;
    dev_t		 st_dev;
    ino_t		 st_ino;
    wave_header_t	*header;
    data_chunk_t	*data_chunk;
    snd_info_t		 info;
    size_t		 mmap_size;	/* includes header */
    void		*mmap_file;	/* entire file */
    size_t		 data_offset;	/* not the chunk! */
    uint		 data_size;	/* without header */
    void		*data;		/* actual sample data */
    struct _dcache	*dcache;	/* display cache */

    guint32		 undo_cnt;	/* how many undo's are in the list */
    struct undo_s	*undo;		/* list of undo's */
    struct undo_s	*clip;		/* last cut/copy'd region */
    guint32		 markers;	/* marker count */
    smpl_indx		*marker;	/* marker array */
    int			 marker_sel;	/* current selected marker */
};

void	 snd_file_close       (snd_buf_t *snd_buf);
gboolean snd_file_open        (snd_buf_t *snd_buf);
void	 snd_file_marker_add  (snd_buf_t *sb, smpl_indx sample);
void	 snd_file_marker_del  (snd_buf_t *sb, int indx);
gboolean snd_file_save        (snd_buf_t *snd_buf);
void	 snd_file_sync        (snd_buf_t *snd_buf);
void	 snd_file_resize      (snd_buf_t *snd_buf, smpl_indx samples);
gboolean snd_file_header_save (int fd, snd_info_t sound_info);

#endif /* _SND_BUF_H */
