// $Id: safemap.hh,v 1.7 2003/05/05 09:58:23 christof Exp $

#include <map>
//#include <cstdio>

#define DEBUG(x)

// The reason for this class is that the execution order of static
// class initializers is unpredictable.
// Since many static ctors used the map before it was constructed I wrapped
// it in this class.

template <class _Key,class _Tp> 
 class safemap
{public:
  typedef _Key key_type;
  typedef _Tp data_type;
  typedef _Tp mapped_type;
private:
  typedef std::map<_Key,_Tp> _Rep_type;
public:
  typedef typename _Rep_type::value_type value_type;
  typedef typename _Rep_type::pointer pointer;
  typedef typename _Rep_type::const_pointer const_pointer;
  typedef typename _Rep_type::reference reference;
  typedef typename _Rep_type::const_reference const_reference;
  typedef typename _Rep_type::iterator iterator;
  typedef typename _Rep_type::const_iterator const_iterator;
  typedef typename _Rep_type::reverse_iterator reverse_iterator;
  typedef typename _Rep_type::const_reverse_iterator const_reverse_iterator;
  typedef typename _Rep_type::size_type size_type;
  typedef typename _Rep_type::difference_type difference_type;

private:
	_Rep_type *m;
	
	void init() { if (!m) { m=new _Rep_type; DEBUG(std::cerr << "safemap new\n"); }}
public:
	// NOTICE: member functions might got called before we
	//         enter the ctor, NEVER touch m unconditionally here
	safemap() { init(); DEBUG(std::cerr << "safemap ctor\n"); } 
	~safemap() { delete m; m=0; DEBUG(std::cerr << "safemap dtor\n"); }
	
  iterator begin() { init(); DEBUG(std::cerr << "safemap begin\n"); return m->begin(); }
  const_iterator begin() const { init(); DEBUG(std::cerr << "safemap cbegin\n"); return m->begin(); }
  iterator end() { init(); return m->end(); }
  const_iterator end() const { init(); return m->end(); }
  reverse_iterator rbegin() { init(); return m->rbegin(); }
  const_reverse_iterator rbegin() const { init(); return m->rbegin(); }
  reverse_iterator rend() { init(); return m->rend(); }
  const_reverse_iterator rend() const { init(); return m->rend(); }
  bool empty() const { init(); return m->empty(); }
  size_type size() const { init(); return m->size(); }
  size_type max_size() const { init(); return m->max_size(); }
  _Tp& operator[](const key_type& k) { init(); DEBUG(std::cerr << "safemap []\n"); return (*m)[k]; }
  iterator find(const key_type& __x) { init(); DEBUG(std::cerr << "safemap find\n"); return m->find(__x); }
};
