/*        gfs_dnd.c - Functions for handling drag and drop files  -  S.Ekanth             */


#include "gfs_defs.h"
#include "support.h"
#include "interface.h"
#include "gfs_dnd.h"



GtkTargetEntry dnd_mime[] = { {"text/uri-list", 0, 1} };

void gfs_dnd_get_target (GtkWidget *widget, GdkDragContext *context,
			  gint x, gint y, GtkSelectionData *selection_data,
			  guint info, guint time, gpointer data)
{
  GList *textlist = NULL;
  gchar* filename;

  if (info == 1)
    textlist = gnome_uri_list_extract_filenames (selection_data->data);
    filename = (gchar *) g_malloc0 (strlen (textlist->data)+1);
    strcpy (filename, textlist->data);
    gnome_uri_list_free_strings (textlist);
    
    slice = create_slice ();
    gtk_widget_show (slice);

    widget = lookup_widget(slice, "combo_entry1");
    gtk_entry_set_text(GTK_ENTRY(widget),filename);
}

void gfs_dnd_init (void)
{
  GtkWidget *dnd_widget;

  dnd_widget = lookup_widget (gfslicer, "text1");
  gtk_drag_dest_set (dnd_widget,
		     GTK_DEST_DEFAULT_ALL,
		     dnd_mime,
		     1,
		     GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (dnd_widget),
		      "drag_data_received",
		      GTK_SIGNAL_FUNC (gfs_dnd_get_target),
		      NULL);
}
