import gobject
import gtk
import tiling
import sys

try:
    import gnomevfs
except ImportError:
    import gnome.vfs as gnomevfs

#
# Image widget that supports tiling.
#
class TilingImage(gtk.Image):

    def __init__(self):

        self.__pixbuf = None
        self.__size = (1, 1)
        self.__is_invalidated = True

        gtk.Image.__init__(self)



    #
    # Sets the image from a color string.
    #
    def set_from_color(self, color):

        if (color[0] == "#" and len(color) == 9):
            alpha = int(color[-2:], 16)
            color = color[:-2]
        else:
            alpha = 255

        w, h = self.__size
        if (not self.__pixbuf):
            self.__pixbuf = gtk.gdk.Pixbuf(0, 1, 8, 320, 32)
        c = gtk.gdk.color_parse(color)
        fillcolor = int('0x%02x%02x%02x%02x' % (c.red / 256, c.green / 256,
                                                c.blue / 256, alpha), 16)
        self.__pixbuf.fill(fillcolor)

        self.__is_invalidated = True
        self.tile(w, h)



    #
    # Sets the image from a file.
    #
    def set_from_file(self, uri):

        if (gnomevfs.exists(uri)):
            data = gnomevfs.read_entire_file(uri)
            loader = gtk.gdk.PixbufLoader()
            try:
                loader.write(data, len(data))
                loader.close()
            except:
                print "Invalid file format"
                loader.close()
            self.__pixbuf = loader.get_pixbuf()
            w, h = self.__size
            self.__is_invalidated = True
            self.tile(w, h)



    #
    # Tiles the background image over the visible area.
    #
    def tile(self, width, height):

        if (not self.__is_invalidated and (width, height) == self.__size):
            return

        self.__is_invalidated = False
        self.__size = (width, height)

        if (not self.__pixbuf): return
        w = self.__pixbuf.get_width()
        h = self.__pixbuf.get_height()
        width = max(width, 1)
        height = max(height, 1)

        tiling.tile_on_image (self, self.__pixbuf, width, height)
