/*
** The cvsgui protocol used by WinCvs
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
** 
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * gimpprotocol.h from the GIMP modified for the cvsgui project by :
 * Alexandre Parenteau <aubonbeurre@hotmail.com> --- January 2000
 */

#ifndef CVSGUI_PROTOCOL_H
#define CVSGUI_PROTOCOL_H

#include "cvsgui_wire.h"

enum {
	GP_QUIT,
	GP_GETENV,
	GP_CONSOLE
};

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	gint32 code;
} GPT_QUIT;

typedef struct
{
	guint8 empty;
	char *str;
} GPT_GETENV;

typedef struct
{
	guint8 isStderr;
	guint32 len;
	char *str;
} GPT_CONSOLE;

int  gp_quit_write (pipe_t fd, int code);
int  gp_getenv_write (pipe_t fd, const char *env);
int  gp_console_write (pipe_t fd, const char *str, int len, int isStderr);
char *gp_getenv_read (pipe_t fd);

extern pipe_t _cvsgui_readfd;
extern pipe_t _cvsgui_writefd;

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_PROTOCOL_H */
