/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* #include "/usr/include/dmalloc.h" */

#include <stdio.h>
#include <sys/types.h>

/* get ENABLE_NLS before libintl.h! */
#include "config.h"                                                                                    
#include <libintl.h>

#define _(x) gettext(x)
#define N_(x) (x)

/* global constant for all buffers - makes it easier to find the places
 * buffers are used if I ever get around implementing a smarter use of
 * buffers */

#define BUF_S 512

/* stuff that must be able to be called everywhere */

void exit_program(void);

/* functions by which the code file- and structurewise is split */

void create_options(GtkWidget *);

/* global configuration objects */

	/* mkisofs */
typedef struct {
	GtkWidget *widget;
	gchar *cmd_line;
	gchar *descr;
	gchar *tool_tip;
	gboolean default_state;
} options;

extern options mkisofs_options[];
extern options mkisofs_special_options[];
extern options mkisofs_text_options[];
extern options mkhybrid_options[];
extern options mkhybrid_text_options[];
extern options torito_options[];

extern int m_o_length;
extern int m_o_s_length;
extern int m_o_t_length;
extern int h_o_length;
extern int torito_length;

/* global constants */

#define BUF_MKISOFS_STDERR 1
#define BUF_MKISOFS_STDOUT 2
#define BUF_CDRECORD_STDERR 4
#define BUF_CDRECORD_STDOUT 8

#define TIMEOUT_GTK 400

