#import "InstallerMedia.h"
#import "InstallerController.h"
#import "InstallerTools.h"

extern BOOL lockedComponents;

@implementation InstallerMedia

- (IBAction)choiceChanged:(id)sender
{
	[controller updateTotalDownload];
}

- (NSString *)destinationPath
{
	return [componentsPath stringByAppendingString:kMediaPackageName];
}

- (NSURL *)downloadURL
{
	if (!alreadyDownloaded && [radios selectedRow] == 0)
		return [NSURL URLWithString:kMediaDownloadURL];
	
	return NULL;
}

- (int)downloadSize
{
	if (!alreadyDownloaded && [radios selectedRow] == 0)
		return kMediaPackageSize;
		
	return 0;
}

- (BOOL)expand
{	
	NSArray *arguments;
	NSTask *task;
	
	if ([radios selectedRow] == 0 || [radios selectedRow] == 1) {
	
		// First move the component into temporary space
		if ([radios selectedRow] == 0)
			[fileManager copyPath:[componentsPath stringByAppendingString:kMediaPackageName] toPath:[temporaryPath stringByAppendingString:@"data.tar.gz"] handler:nil];
		if (shiftNeeded && [radios selectedRow] == 1)
			[fileManager copyPath:shiftPath toPath:[temporaryPath stringByAppendingString:@"data.tar.gz"] handler:nil];
		
		// Put files in place
		if (!directMove) {
			[[controller tools] gunzip:[temporaryPath stringByAppendingString:@"data.tar.gz"]];
			[[controller tools] tar:[temporaryPath stringByAppendingString:@"data.tar"] destination:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources"]];
		}
		else {
			[fileManager copyPath:[componentsPath stringByAppendingString:kMediaPackageName] toPath:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data"] handler:nil];
		}
		
		// Get rid of the leftovers
		if (!directMove)
			[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"data.tar"] handler:nil];
	
	}
	else {
		
		// Copy skeleton WC2 "data" folder into position
		[fileManager copyPath:[resourcesPath stringByAppendingString:@"data"] toPath:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data"] handler:nil];
		
		// Set up arguments
		arguments = [NSArray arrayWithObjects:@"./dummy", [[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data"], nil];
			
		// Run task
		task = [NSTask launchedTaskWithLaunchPath:[resourcesPath stringByAppendingString:@"WarTool.app/Contents/MacOS/WarTool"] arguments:arguments];
		[task waitUntilExit];
		
		// Check that the utility executed properly
		if (![fileManager fileExistsAtPath:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data/graphics"]]) {
			NSRunAlertPanel(@"Installation Failed", @"The installation of FreeCraft has failed due to a problem with the wartool utility. As a result, this installer will now quit.", @"Ok", NULL, NULL);
			return NO;
		}

	}
	
	// Set data members appropriately
	if (directMovePath != NULL) [directMovePath autorelease];
	if (shiftPath != NULL) [shiftPath autorelease];
	directMovePath = NULL;
	shiftPath = NULL;
	
	return YES;
}

- (id)init
{
	// Call the super
	if ([super init] == NULL)
		return NULL;
	
	// These should be done for us, but you can never be too careful
	directMovePath = NULL;
	shiftPath = NULL;
	
	return self;
}

- (BOOL)prepare
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	NSString *tempPath;
	BOOL success = NO;
	int returnCode;
	BOOL valid = NO;
	
	// Set variables appropriately
	directMove = NO;
	shiftNeeded = NO;
	
	// Remove any existing temporary files
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"data.tar.gz"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"data.tar.gz"] handler:nil];
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"data.tar"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"data.tar"] handler:nil];
	
	// If no further preparation is necessary leave
	if ([radios selectedRow] == 0)
		return YES;
		
	// If selection is required do so
	if ([radios selectedRow] == 1) {
		
		// Otherwise, setup the selection panel
		[openPanel setCanChooseDirectories:YES];
		[openPanel setCanChooseFiles:YES];
		[openPanel setAllowsMultipleSelection:NO];
		[openPanel setPrompt:@"Select"];
		[openPanel setTitle:@"Select Media"];
		
		// Run the selection panel
		if ([openPanel runModalForTypes:NULL] == NSOKButton) {
			tempPath = [[openPanel filenames] objectAtIndex:0];
			if ([[tempPath lastPathComponent] isEqualToString:@"data"]) {
			
				// A raw data folder has been selected
				if (NSRunAlertPanel(@"StuffIt Expander Incompatibility", @"You have elected that the installer use an uncompressed data folder, this is okay except that such a folder should contain long file names which may be truncated by some decompression utilities such as StuffIt Expander. If such file names are truncated FreeCraft may misbehave or fail to load. Do you still wish to proceed with installation?", @"Yes", @"No", NULL) == NSAlertDefaultReturn) {
					directMovePath = [tempPath retain];
					directMove = YES;
					success = YES;
				}
				
			}
			else {
				
				// A ".gz" document has been selected
				if ([[tempPath pathExtension] isEqualToString:@"gz"] || [[tempPath pathExtension] isEqualToString:@"tgz"]) {
					shiftPath = [tempPath retain];
					shiftNeeded = YES;
					success = YES;
				}
				else {
					NSRunAlertPanel(@"Media Selection Invalid", @"The choice you made does not seem to be either a folder named \"data\" or a file with extension \".gz\" or \".tgz\" that might contain such a folder. As such installation cannot proceed.", @"Ok", NULL, NULL, NULL);
				}
			
			}
		}

	}
	
	// If we are using WarCraft II CD
	if ([radios selectedRow] == 2) {
	
tryagain:
		
		// Try and detect a WarCraft II CD
		valid = NO;
		if ([fileManager fileExistsAtPath:@"/Volumes/WarCraft II CD/Data"]) valid = YES;
		if ([fileManager fileExistsAtPath:@"/Volumes/WarCraft IIx CD/Data"]) valid = YES;
		if ([fileManager fileExistsAtPath:@"/Volumes/WARCRAFT2/data"]) valid = YES;
		if ([fileManager fileExistsAtPath:@"/Volumes/WARCRAFT2_X/data"]) valid = YES;
		
		// If none is found complain
		if (!valid) {
			returnCode = NSRunAlertPanel(@"Cannot Find WarCraft II CD", @"A WarCraft II CD cannot be found please insert the CD and press \"Try Again\" to try again or \"Abort\" to return to the setup screen. If you have a legitimate WarCraft II CD that is not being detected, please press \"Continue\" and at the prompt type the name of the WarCraft II CD exactly as it appears in the Finder.", @"Try Again", @"Abort", @"Continue");
			switch (returnCode) {
				case NSAlertDefaultReturn:
					goto tryagain;
				break;
				case NSAlertAlternateReturn:
					return NO;
				break;
			}
			
		}
		
		success = YES;
		
	}
	
	return success;
}

- (void)setup
{
	BOOL doesExist;
	NSString *tempPath;
	
	// Search for the compressed package in the "Components" folder
	tempPath = [componentsPath stringByAppendingString:kMediaPackageName];
	doesExist = [fileManager fileExistsAtPath:tempPath];
	if (doesExist) {
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to install the free media provided"];
		[radios selectCellAtRow:0 column:0];
		alreadyDownloaded = YES;
	}
	else {
		alreadyDownloaded = NO;
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to download and install the free media"];
		if (lockedComponents) {
			[radios setEnabled:NO];
			[radios selectCellAtRow:1 column:0];
		}
	}
	
	// Set data members appropriately
	if (directMovePath != NULL) [directMovePath autorelease];
	if (shiftPath != NULL) [shiftPath autorelease];
	directMovePath = NULL;
	shiftPath = NULL;
}

- (BOOL)useLowRes
{
	return ([radios selectedRow] == 2);
}

@end
