<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="yes" encoding="UTF-8" />

<xsl:variable name="title" select="'Ledger overview'"/>

<xsl:template match="/">	
<html>
<head>
  <title><xsl:value-of select="$title" /></title>
   <link rel="stylesheet" href="http://www.piware.de/fibu/fibu.css" />
</head>

<body>
    <h1><xsl:value-of select="$title"/> - 
    &quot;<xsl:value-of select="/ledger/account/@name" />&quot;</h1>

    <table class="booktbl">
      <tr>
        <th class="num">Debit</th>
        <th class="num">Credit</th>
	<th>Account</th>
      </tr>
      <xsl:for-each select="/ledger/account">
	<xsl:apply-templates>
	  <xsl:sort select="@number" data-type="number" />
	</xsl:apply-templates>
      </xsl:for-each>
    </table>
</body>
</html>
</xsl:template>    

<xsl:template match="account">
  <tr>
    <xsl:choose>
      <xsl:when test="@type='asset' or @type='expense'">
    <td class="num"><xsl:value-of select="format-number(@balance,'0.00')" /></td>
    <td></td>
      </xsl:when>

      <xsl:otherwise>
    <td></td>
    <td class="num"><xsl:value-of select="format-number(-@balance,'0.00')" /></td>
      </xsl:otherwise>
    </xsl:choose>

    <td>(<xsl:value-of select="@number" />) <xsl:value-of select="@name" /></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
