# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the input dialog wizard dialog.
"""

import os

from qt import *

from InputDialogWizardForm import InputDialogWizardForm

class InputDialogWizardDialog(InputDialogWizardForm):
    """
    Module implementing the input dialog wizard dialog.
    
    It displays a dialog for entering the parameters
    for the QInputDialog code generator.
    
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent -- parent widget (QWidget)
        """
        InputDialogWizardForm.__init__(self, parent, None, 1)
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
        # set the validators for the double line edots
        self.eDoubleDefault.setValidator(\
            QDoubleValidator(-2147483647, 2147483647, 99, self.eDoubleDefault))
        self.eDoubleFrom.setValidator(\
            QDoubleValidator(-2147483647, 2147483647, 99, self.eDoubleFrom))
        self.eDoubleTo.setValidator(\
            QDoubleValidator(-2147483647, 2147483647, 99, self.eDoubleTo))
        
    def testDlg(self):
        """
        Private method to test the selected options.
        """
        if self.rText.isOn():
            if self.rEchoNormal.isOn():
                echomode = QLineEdit.Normal
            elif self.rEchoNoEcho.isOn():
                echomode = QLineEdit.NoEcho
            else:
                echomode = QLineEdit.Password
            QInputDialog.getText(\
                self.eCaption.text(),
                self.eLabel.text(),
                echomode,
                self.eTextDefault.text())
        elif self.rInteger.isOn():
            QInputDialog.getInteger(\
                self.eCaption.text(),
                self.eLabel.text(),
                self.sIntDefault.value(),
                self.sIntFrom.value(),
                self.sIntTo.value(),
                self.sIntStep.value())
        elif self.rDouble.isOn():
            try:
                doubleDefault = float(str(self.eDoubleDefault.text()))
            except:
                doubleDefault = 0
            try:
                doubleFrom = float(str(self.eDoubleFrom.text()))
            except:
                doubleFrom = -2147483647
            try:
                doubleTo = float(str(self.eDoubleTo.text()))
            except:
                doubleTo = 2147483647
            QInputDialog.getDouble(\
                self.eCaption.text(),
                self.eLabel.text(),
                doubleDefault,
                doubleFrom,
                doubleTo,
                self.sDoubleDecimals.value())
        
    def getCode(self, indLevel, indString):
        """
        Public method to get the source code.
        
        @param indLevel -- indentation level (int)
        @param indString -- string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QInputDialog.'
        if self.rText.isOn():
            code += 'getText(\\%s%s' % (os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eLabel.text()), os.linesep, istring)
            if self.rEchoNormal.isOn():
                code += 'QLineEdit.Normal'
            elif self.rEchoNoEcho.isOn():
                code += 'QLineEdit.NoEcho'
            else:
                code += 'QLineEdit.Password'
            if not self.eTextDefault.text().isEmpty():
                code += ',%s%sself.trUtf8("%s")' % \
                    (os.linesep, istring, unicode(self.eTextDefault.text()))
            code += ')%s' % os.linesep
        elif self.rInteger.isOn():
            code += 'getInteger(\\%s%s' % (os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eLabel.text()), os.linesep, istring)
            code += '%d, %d, %d, %d)%s' % \
                (self.sIntDefault.value(), self.sIntFrom.value(),
                self.sIntTo.value(), self.sIntStep.value(), os.linesep)
        elif self.rDouble.isOn():
            try:
                doubleDefault = float(str(self.eDoubleDefault.text()))
            except:
                doubleDefault = 0
            try:
                doubleFrom = float(str(self.eDoubleFrom.text()))
            except:
                doubleFrom = -2147483647
            try:
                doubleTo = float(str(self.eDoubleTo.text()))
            except:
                doubleTo = 2147483647
            code += 'getDouble(\\%s%s' % (os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (str(self.eCaption.text()), os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eLabel.text()), os.linesep, istring)
            code += '%s, %s, %s, %d)%s' % \
                (str(doubleDefault), str(doubleFrom), str(doubleTo), 
                self.sDoubleDecimals.value(), os.linesep)
        elif self.rItem.isOn():
            code += 'getItem(\\%s%s' % (os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'self.trUtf8("%s"),%s%s' % \
                (unicode(self.eLabel.text()), os.linesep, istring)
            code += '%s,%s%s' % (unicode(self.eVariable.text()), os.linesep, istring)
            code += '%d, %d)%s' % \
                (self.sCurrentItem.value(), self.cEditable.isOn(), os.linesep)
            
        return code
