#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static gint
set_arrow_position (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *arrow;

    arrow = enode_get_kv (node, "top-widget");

    EDEBUG (("arrow-renderer", "setting arrow position to %i",
		value->str));

    if (ebuf_equal_str (value, "up"))
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_UP, GTK_SHADOW_OUT);
    else if (ebuf_equal_str (value, "down"))
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_DOWN, GTK_SHADOW_OUT);
    else if (ebuf_equal_str (value, "right"))
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
    else if (ebuf_equal_str (value, "left"))
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_LEFT, GTK_SHADOW_OUT);
    else
	EDEBUG (("arrow-renderer", 
		    "value '%s' doesn't match 'up' 'down' 'right' or 'left'",
		    value->str));

    return TRUE;
}

static void
rendgtk_arrow_render (ENode * node)
{
    GtkWidget *arrow;

    EDEBUG (("arrow-renderer", "in rendgtk_arrow_render"));

    arrow = gtk_arrow_new (GTK_ARROW_UP, GTK_SHADOW_OUT);

    enode_set_kv (node, "top-widget", arrow);
    enode_set_kv (node, "bottom-widget", arrow);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, arrow);
}


void
arrow_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_arrow_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "arrow";
    element->description = "Create a new arrow widget";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "position";
    e_attr->description = "Direction Arrow points in 90 degree increments";
    e_attr->value_desc = "choice";
    e_attr->possible_values = "up,down,left,right";
    e_attr->set_attr_func = set_arrow_position;
    element_register_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_ARROW);
}

