#ifndef __EUTILS_H__
#define __EUTILS_H__

#include <glib.h>
#include <gmodule.h>

#define ECHECK_DEBUG 1

#ifdef ECHECK_DEBUG
#define ECHECK_RET(expr) 		g_return_if_fail(expr)
#define ECHECK_RETVAL(expr, val) 	g_return_val_if_fail(expr,val)
#define ECHECK(expr) 			g_assert(expr)

#else				/* not ECHECK_DEBUG */

#define ECHECK_RET(expr) 	G_STMT_START{		\
			     	if (!(expr))		\
					return;		\
	       			}G_STMT_END

#define ECHECK_RETVAL(expr,val)	G_STMT_START{		\
			     	if (!(expr))		\
					return(val);	\
	       			}G_STMT_END

#define ECHECK(expr)		G_STMT_START{		\
	       			}G_STMT_END


#endif				/* ECHECK_DEBUG */

GSList *eutils_hash_key_list (GHashTable * table, GSList * list);

GSList *eutils_hash_value_list (GHashTable * table, GSList * list);

gint eutils_file_exists (gchar * filename);

gchar *eutils_file_search (ENode * node, gchar * filename);

/* extract the full filename from a .la file.  This seems to * be the only
 * portable way to dlopen () a libtool library */

gchar *eutils_module_dlname (gchar * lafile);

GModule *eutils_load_module (gchar * module);

/* Memory chunk allocator interface */

/* #define EMEMCHUNK_PROFILE 1 */


typedef struct _EMemChunk EMemChunk;

struct _EMemChunk {
    GSList *free_list;
    guint size;
    guint alloc_num;
    guint num_free_chunks;

#ifdef EMEMCHUNK_PROFILE
    gint number_of_freed_chunks;
    gint number_of_used_chunks;
    gint number_of_allocated_chunks;
#endif

};

EMemChunk *eutils_memchunk_admin_new (guint chunk_size, guint alloc_num);

void *eutils_memchunk_alloc (EMemChunk * chunk);

void
 eutils_memchunk_free (EMemChunk * chunk, void *buf);

void
 eutils_memchunk_stats (EMemChunk * chunk);

#endif				/* __EUTILS_H__ */


