#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include "entity.h"

/* Returns true if the string value has truth. */
gint erend_value_is_true (EBuf * value)
{
    gint istrue = FALSE;
    EBuf *val;

    if (!value)
	return (FALSE);

    val = ebuf_new_with_ebuf (value);
    ebuf_down (val);

    if (ebuf_equal_str (val, "yes") ||
	ebuf_equal_str (val, "true") ||
	ebuf_equal_str (val, "on") || atoi (value->str)) {
	istrue = TRUE;
    }

    ebuf_free (val);

    return (istrue);
}


gfloat erend_get_percentage (EBuf * value)
{
    gfloat val;
    val = atoi (value->str) / 100.0;

    EDEBUG (("erend", "value = %s, percent = %f", value->str, val));

    return (val);
}

gfloat erend_get_float (EBuf * value)
{
    gfloat val = 0.0;

    if (ebuf_empty (value))
	return (0.0);

    sscanf (value->str, "%f", &val);

    return (val);
}

gint erend_get_integer (EBuf * value)
{
    gint val;

    if (!value)
	return 0;
    val = atoi (value->str);

    return (val);
}

void
erend_short_curcuit_parent (ENode * parent_node, ENode * child_node)
{
    ENode *parent_parent = parent_node;

    if (!child_node->entity_data)
	return;

    /* Search for a parent with entity_data to parent against. */
    do {
	parent_parent = enode_parent (parent_parent, NULL);
	if (!parent_parent)
	    return;
    } while (parent_parent->entity_data == NULL);

    enode_event_parent (parent_parent, child_node);
}


