#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../include/string.h"

#include "guiutils.h"

#include "cfg.h"
#include "optwin.h"
#include "edvcustomize.h"
#include "endeavour.h"
#include "edvutilsgtk.h"

#include "edvcfglist.h"
#include "config.h"

#include "images/icon_customize_48x48.xpm"
#include "images/icon_endeavour_logo_20x20.xpm"
#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/icon_trash_20x20.xpm"


/* Utils */
gchar *EDVCustomizeSimplifyOPIDName(const gchar *name);

/* General */
#if 0
void EDVCustomizeGeneralCreateNewObjectsMenuPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
#endif
void EDVCustomizeGeneralCreateStylesPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeGeneralCreateAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* Customize Window */
void EDVCustomizeWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
);
optwin_struct *EDVCustomizeWindowNew(edv_core_struct *core_ptr);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns a simplified Operation ID menu name.
 *
 *	Removes all occurances of "_" and "..." in the specified name.
 *
 *	The calling function must delete the returned string.
 */
gchar *EDVCustomizeSimplifyOPIDName(const gchar *name)
{
	gchar *s, *name_rtn = STRDUP(name);

	s = strsub(name_rtn, "_", "");
	g_free(name_rtn);
	name_rtn = s;

	s = strsub(name_rtn, "...", "");
	g_free(name_rtn);
	name_rtn = s;

	return(name_rtn);
}


#if 0
/*
 *	Creates the General New Objects Menu page.
 */
void EDVCustomizeGeneralCreateNewObjectsMenuPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{





}
#endif

/*
 *	Creates the General Styles page.
 */
void EDVCustomizeGeneralCreateStylesPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5, 
			border_minor = 2; 
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	style_edit_struct *se;

	/* Styles Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Override GTK Style Check */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Caso Omiso El Estilo De GTK"
#elif defined(PROG_LANGUAGE_FRENCH)
"Annuler Le Style De GTK"
#elif defined(PROG_LANGUAGE_GERMAN)
"Heben Sie GTK Stil Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Annullare Lo Stile Di GTK"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hef GTK Stijl Op"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Estilo De GTK"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilsidesettende GTK Stil"
#else
"Override GTK Style"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL, EDV_CFG_PARM_GTK_STYLE_OVERRIDE
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Standard Style Edit */
	se = StyleEditNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo Uniforme"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style Standard"
#elif defined(PROG_LANGUAGE_GERMAN)
"Normaler Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Standard"
#elif defined(PROG_LANGUAGE_DUTCH)
"Normale Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Estilo Normal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Normal Stil"
#else
"Standard Style"
#endif   
	);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL, EDV_CFG_PARM_STYLE_STANDARD 
	);
	OptWinWRefSetStyleEdit(wref, se);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Lists Style Edit */
	se = StyleEditNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo De Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style De Listes"    
#elif defined(PROG_LANGUAGE_GERMAN)
"Listen Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Di Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Lijsten Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo De Listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Liste Stil"
#else
"Lists Style"
#endif   
	);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL, EDV_CFG_PARM_STYLE_LISTS    
	);
	OptWinWRefSetStyleEdit(wref, se);
}

/*
 *	Creates the General Appearance page.
 */
void EDVCustomizeGeneralCreateAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;


	/* Window Placement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Colocacin De La Ventana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Placement De Fentre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster Unterbringung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Collocamento Di Finestra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Raam Plaatsing"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Colocao De Janela"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vindu Plassering"
#else
"Window Placement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for Window Cascade Offset X */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Desviacin De La Cascada"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Cascade A Dcal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Strzen Sie Ausgleich Herab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cascata Contrappone"
#elif defined(PROG_LANGUAGE_DUTCH)
"Val Compensatie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cascata Compensar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Cascade Motvekt"
#else
"Cascade Offset"
#endif
	    " X:"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Cascade Offset X Spin */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, -100000.0f, 100000.0f,
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X
	);

	/* Label */
	w = gtk_label_new("Y:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Cascade Offset Y Spin */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, -100000.0f, 100000.0f,
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y
	);


	/* Tool Tips Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Instrumento Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Ferramenta Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Velter"
#else
"Tool Tips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for Show Tooltips & Texttips */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Show Tooltips Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Instrumento De La Exposicin Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie Werkzeug Spitzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Aan Werktuig Fooien"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ferramenta De Exposio Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis RedskapTupper"
#else
"Show Tooltips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SHOW_TOOLTIPS
	);

	/* Show Texttips Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Texto De La Exposicio'n Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schauentext Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Testo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"De Vertoning Tekst Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Texto De Exposic"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstillingstekst Velter"
#else
"Show Texttips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SHOW_TEXTTIPS
	);



}

/*
 *	Selects the notebook tab specified by tab_name for the given
 *	customize window.
 */
void EDVCustomizeWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
)
{
	gint page_num;
	GtkNotebook *notebook;


	if(optwin == NULL)
	    return;

	notebook = (GtkNotebook *)optwin->notebook;
	if(notebook == NULL)
	    return;

	/* Tab name given? */
	if(!STRISEMPTY(tab_name))
	{
	    /* Handle by tab name */
	    if(!g_strcasecmp(tab_name, "Global") ||
	       !g_strcasecmp(tab_name, "General")
	    )
		page_num = 0;
	    else if(!g_strcasecmp(tab_name, "File Browser"))
		page_num = 1;
	    else if(!g_strcasecmp(tab_name, "Image Browser"))
		page_num = 2;
	    else if(!g_strcasecmp(tab_name, "Archiver"))
		page_num = 3;
	    else if(!g_strcasecmp(tab_name, "Recycle Bin"))
		page_num = 4;
	    else
	    {
		page_num = -1;
		g_printerr(
"EDVCustomizeWindowSelectTab(): Warning:\
 Invalid tab name \"%s\".\n",
		    tab_name
		);
	    }
	}
	else
	{
	    page_num = 0;
	}

	/* Got valid page? */
	if(page_num > -1)
	    gtk_notebook_set_page(notebook, page_num);
}

/*
 *	Creates a new customize window.
 */
optwin_struct *EDVCustomizeWindowNew(edv_core_struct *core_ptr)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent, *parent2;
	optwin_struct *optwin = OptWinNew(
	    core_ptr,
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Personal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Personnaliser"
#elif defined(PROG_LANGUAGE_GERMAN)
"Passen Sie An"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Personalizzare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Aanpas"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Pessoal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Personlig"
#else
"Customize"
#endif
	    , (guint8 **)icon_customize_48x48_xpm
	);
	if(optwin == NULL)
	    return(optwin);


	/* Create the General page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_endeavour_logo_20x20_xpm,
	    "icon_endeavour_logo_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Global"
#elif defined(PROG_LANGUAGE_FRENCH)
"Global"
#elif defined(PROG_LANGUAGE_GERMAN)
"Global"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Globale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Globaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Global"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Global"
#else
"Global"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* GtkNotebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeGeneralCreateAppearancePage(
		core_ptr, optwin, w
	    );

	    /* Styles Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
		)
	    );   
	    gtk_widget_show(w);
	    EDVCustomizeGeneralCreateStylesPage(
		core_ptr, optwin, w
	    );

#if 0
	    /* New Objects Menu */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
"New Objects Menu"
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeGeneralCreateNewObjectsMenuPage(
		core_ptr, optwin, w
	    );
#endif

	}

	/* Begin creating the File Browser Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)endeavour_20x20_xpm,
	    "endeavour_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Archive A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Classer Le Navigateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datei Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Schedare Il Browser"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archiveer Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquive Browser"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiver Browser"
#else
"File Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* GtkNotebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeBrowserCreateAppearancePage(
		core_ptr, optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeBrowserCreateToolBarPage(
		core_ptr, optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeBrowserCreateContentsListPage(
		core_ptr, optwin, w
	    );

	    /* Keymaps Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(  
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeBrowserCreateKeymapsPage(
		core_ptr, optwin, w
	    );
	}

	/* Begin creating the Image Browser page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)image_browser_20x20_xpm,
	    "image_browser_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Imagine A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Navigateur D'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Browser Di Immagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Browser De Imagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde Browser"
#else
"Image Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* GtkNotebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeImbrCreateAppearancePage(
		core_ptr, optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeImbrCreateToolBarPage(
		core_ptr, optwin, w
	    );

	    /* Thumbs List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista De Pulgares"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Pouces Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Daumen Fhren Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Pollici"
#elif defined(PROG_LANGUAGE_DUTCH)
"Duimen Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Polegares Alistam"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tommelfinger Lister Opp"
#else
"Thumbs List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeImbrCreateThumbsListPage(
		core_ptr, optwin, w
	    );

	    /* Keymaps Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen" 
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else         
"Keymaps"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeImbrCreateKeymapsPage(
		core_ptr, optwin, w
	    );

	    /* Presentation Mode Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Modo De Presentacio'n"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mode De Pre'sentation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vorstellungsmodus"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Modo Di Presentazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Voorstelling Modus"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Modo De Apresentacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"FramstillingsModus"
#else
"Presentation Mode"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeImbrCreatePresentationPage(
		core_ptr, optwin, w
	    );
	}

	/* Begin creating the Archiver Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)archiver_20x20_xpm,
	    "archiver_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Fabricante Del Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archiver Le Fabricant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archivieren Sie Hersteller"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Fabbricante Di Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief Maker"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Criador De Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv Skaper"
#else
"Archiver"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* GtkNotebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeArchiverCreateAppearancePage(
		core_ptr, optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeArchiverCreateToolBarPage(
		core_ptr, optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeArchiverCreateContentsListPage(
		core_ptr, optwin, w
	    );

	    /* Keymaps Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeArchiverCreateKeymapsPage(
		core_ptr, optwin, w
	    );
	}

	/* Begin creating the Recycle Bin Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_trash_20x20_xpm,
	    "icon_trash_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Cajn De Refycle"
#elif defined(PROG_LANGUAGE_FRENCH)
"Refycle Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Refycle Behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Recipiente Di Refycle"
#elif defined(PROG_LANGUAGE_DUTCH)
"Refycle Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Caixa De Refycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Refycle Beholder"
#else
"Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* GtkNotebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeRecBinCreateAppearancePage(
		core_ptr, optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeRecBinCreateToolBarPage(
		core_ptr, optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeRecBinCreateContentsListPage(
		core_ptr, optwin, w
	    );

	    /* Keymaps Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCustomizeRecBinCreateKeymapsPage(
		core_ptr, optwin, w
	    );
	}





	return(optwin);
}
