#ifndef ARCHIVEINFO_H
#define ARCHIVEINFO_H

#include <gtk/gtk.h>
#include "piechart.h"


/*
 *      Archive Info Dialog:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	GdkCursor	*text_cur,
			*busy_cur;

	GtkWidget	*main_vbox,
			*icon_pm,
			*name_label,
			*location_label,
			*comment_text,
			*comment_set_btn,
			*comment_paste_btn,
			*comment_insert_file_btn,
			*ok_btn;

	pie_chart_struct	*piechart;

	gchar		*arch_obj;
	gboolean	has_changes;

} edv_archive_info_struct;
#define EDV_ARCHIVE_INFO(p)	((edv_archive_info_struct *)(p))


extern edv_archive_info_struct *EDVArchiveInfoNew(
	gpointer core_ptr, const gchar *arch_obj,
	GtkWidget *ref_toplevel
);
extern void EDVArchiveInfoResetHasChanges(
        edv_archive_info_struct *d, gboolean has_changes
);
extern void EDVArchiveInfoUpdateMenus(edv_archive_info_struct *d);
extern void EDVArchiveInfoSetBusy(
	edv_archive_info_struct *d, gboolean is_busy
);
extern gboolean EDVArchiveInfoIsMapped(edv_archive_info_struct *d);
extern void EDVArchiveInfoMap(edv_archive_info_struct *d);
extern void EDVArchiveInfoUnmap(edv_archive_info_struct *d);
extern void EDVArchiveInfoDelete(edv_archive_info_struct *d);


#endif	/* ARCHIVEINFO_H */
