/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class CommandTextField
extends Panel {
    private int histSize;
    private int caretPosition;
    private UserOutputArea outputArea;
    HistoryList history;
    String issuedCommand;
    boolean PGDNonKeyDown;
    boolean ancientAWT;
    PipedOutputStream outputStream;
    PipedInputStream inputStream;
    DataOutputStream out;
    TextComponent commandArea;
    Vector modes;
    Mode currentMode;

    CommandTextField(Font font, int n, Vector vector) {
        this.modes = vector;
        this.outputArea = this.outputArea;
        this.currentMode = (Mode)vector.firstElement();
        try {
            this.commandArea = new TextArea("", 3, 20, 3);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.commandArea = new TextArea("", 3, 20);
            this.ancientAWT = true;
        }
        this.histSize = n;
        this.outputStream = new PipedOutputStream();
        this.setLayout(new BorderLayout());
        this.commandArea.setFont(font);
        this.add("Center", this.commandArea);
        this.show();
        try {
            this.inputStream = new PipedInputStream(this.outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out = new DataOutputStream(this.outputStream);
        this.history = new HistoryList("", n);
    }

    public void requestFocus() {
        if (this.ancientAWT) {
            this.commandArea.select(this.commandArea.getText().length(), this.commandArea.getText().length());
        } else {
            this.commandArea.requestFocus();
        }
    }

    public PipedInputStream getInputStream() {
        return this.inputStream;
    }

    private void sendIssuedCommand(String string) {
        try {
            this.out.writeBytes(string + "\n");
            this.out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getIssuedCommand() {
        return this.issuedCommand;
    }

    public void clean() {
        this.commandArea.setText(this.currentMode.getMooCommand());
        try {
            this.commandArea.setCaretPosition(this.commandArea.getText().length());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void cycleUp() {
        this.history.replaceCurrentItem(this.commandArea.getText());
        this.commandArea.setText(this.history.getPreviousItem().toString());
        try {
            this.commandArea.setCaretPosition(this.commandArea.getText().length());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void cycleDown() {
        this.history.replaceCurrentItem(this.commandArea.getText());
        this.commandArea.setText(this.history.getNextItem().toString());
        try {
            this.commandArea.setCaretPosition(this.commandArea.getText().length());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void issueCommand() {
        String string = this.commandArea.getText();
        if (string.trim().equals(this.currentMode.getMooCommand().trim()) && this.currentMode.getMooCommand() != "") {
            return;
        }
        this.history.insertItem(string);
        this.sendIssuedCommand(string);
        this.clean();
    }

    public boolean keyUp(Event event, int n) {
        if (!this.PGDNonKeyDown) {
            switch (n) {
                case 1002: {
                    this.cycleUp();
                    return true;
                }
                case 1003: {
                    this.cycleDown();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 10: {
                this.issueCommand();
                return true;
            }
            case 1002: {
                this.cycleUp();
                this.PGDNonKeyDown = true;
                return true;
            }
            case 1003: {
                this.cycleDown();
                this.PGDNonKeyDown = true;
                return true;
            }
            case 1004: {
                if (event.modifiers == 2) {
                    this.cycleUp();
                    return true;
                }
            }
            case 1005: {
                if (event.modifiers != 2) break;
                this.cycleDown();
                return true;
            }
        }
        return false;
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        this.requestFocus();
        this.clean();
    }

    public void setMode(String string) {
        Mode mode = (Mode)this.modes.firstElement();
        Enumeration enumeration = this.modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode2 = (Mode)enumeration.nextElement();
            if (!mode2.getCaption().equals(string)) continue;
            mode = mode2;
            break;
        }
        this.setMode(mode);
    }

    public Mode getMode() {
        return this.currentMode;
    }
}

