static char rcsid[] = "$Id: oiladt2d.c,v 1.8 1997/09/04 18:21:09 waite Exp $";
/* Oil index translation
   Copyright, 1989, The Regents of the University of Colorado */

/* This file is part of the Eli Module Library.

The Eli Module Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The Eli Module Library is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the Eli Module Library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Eli into the
   directory resulting from a :source derivation, you may use that
   created file as a part of that directory without restriction. */

#include "oiladt2.h"


/*****************************************************
  OilNextName - returns the next available 'name' for use in constructing
      operators, types, and classes
  */
extern int OilMaxName;

oilName OilNextName()
  {
      return( NewName );
  }


/*****************************************************
  OilTypeIndex, OilOpIndex, OilClassIndex - translate indexes into objects
      (the 'maps' are generated by the OIL compiler)
  */

extern tOilType OilTypeMap[];
extern tOilOp OilOpMap[];
extern tOilClass OilClassMap[];

tOilType
#if defined(__cplusplus) || defined(__STDC__)
OilTypeIndex(int index)
#else
OilTypeIndex(index)
int index;
#endif
{ return( OilTypeMap[index] ); }

tOilOp
#if defined(__cplusplus) || defined(__STDC__)
OilOpIndex(int index)
#else
OilOpIndex(index)
int index;
#endif
{ return( OilOpMap[index] ); }

tOilClass
#if defined(__cplusplus) || defined(__STDC__)
OilClassIndex(int index)
#else
OilClassIndex(index)
int index;
#endif
{ return( OilClassMap[index] ); }


/*		- -  the end of 'oiladt2d.c'  - -		*/
