/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SETTINGS_HELP_H
#define SETTINGS_HELP_H

#include "prog_defs.h"

#include <vector>

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <glibmm/ustring.h>



struct SettingsMessagesBase {

  std::vector<Glib::ustring> captions;
  std::vector<Glib::ustring> messages;

  Glib::ustring get_caption(std::vector<Glib::ustring>::size_type);
  Glib::ustring get_message(std::vector<Glib::ustring>::size_type);

  SettingsMessagesBase(std::vector<Glib::ustring>::size_type size): captions(size), messages(size) {}
};

class IdentityMessages: private SettingsMessagesBase {
public:
  enum {name = 0, number};
  IdentityMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class ModemMessages: private SettingsMessagesBase {
public:
  enum {device = 0, lock, modem_class, dialmode, capabilities, rings};
  ModemMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class ParmsMessages: private SettingsMessagesBase {
public:
  enum {init = 0, reset, extra_parms};
  ParmsMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class PrintMessages: private SettingsMessagesBase {
public:
  enum {command = 0, shrink, popup};
  PrintMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class ViewMessages: private SettingsMessagesBase {
public:
  enum {ps_view_command = 0};
  ViewMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class SockMessages: private SettingsMessagesBase {
public:
  enum {run_server = 0, popup, port, client_address};
  SockMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class ReceiveMessages: private SettingsMessagesBase {
public:
  enum {popup = 0, exec};
  ReceiveMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class LoggingMessages: private SettingsMessagesBase {
public:
  enum {logfile = 0};
  LoggingMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class PageMessages: private SettingsMessagesBase {
public:
  enum {page = 0, res};
  PageMessages(void);

  using SettingsMessagesBase::get_caption;
  using SettingsMessagesBase::get_message;
};

class SettingsHelpDialog: public Gtk::Window {
  bool in_exec_loop;
  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void kill_dialog(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  void exec(void);
  SettingsHelpDialog(const int standard_size, const Glib::ustring& text,
		     const Glib::ustring& caption, Gtk::Window&);
};

#endif
