/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for T=0 protocol handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   12/10/1999
 *
 *****************************************************************************/
 
 
#ifndef _ecoT0_H_
#define _ecoT0_H_

#include "eco5000.h"
#include "sercom.h"
#include "ctapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "ecotools.h"


#define CASE1  0x01
#define CASE2  0x02
#define CASE3  0x03
#define CASE4  0x04 


struct ecoT0_t {
       int		cwt;
};


struct cAPDU_t  {
	unsigned char	CLA;
	unsigned char	INS;
	unsigned char	P1;
	unsigned char	P2;
	unsigned char	P3;
	unsigned char	Data[256];
        unsigned char   cmdType;
};
	

int ecoT0Init (struct eco5000_t *ctx);


int ecoT0Process (struct eco5000_t *ctx,
                  unsigned int  lc, 
		  unsigned char *cmd, 
		  unsigned int  *lr,
                  unsigned char *rsp); 


int ecoT0Term (struct eco5000_t *ctx);

#endif









