/*
 *  dlisp / a dancer's lisp parser library
 *  Copyright (C) 2002-2003 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * test application.
 * This is the "dlisp" binary used in the tests.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "dlispparser.h"


/** test function  */
void 
recursively_dump_l(dlisp_lispentry*l)
{
  for (; l; l=l->next)
    {
      switch (l->type)
	{
	case dlisp_quotedtext:
	  printf("\'");
	  recursively_dump_l (l->child);
	  break;
	case dlisp_bracket:
	  printf ("(");
	  recursively_dump_l (l->child);
	  printf (") ");
	  break;
	case dlisp_cdata:
	  printf ("%s ", l->name);
	  break;
	case dlisp_stringconstant:
	  printf ("\"%s\" ", l->name);
	  break;	  
	case dlisp_sharp_vector_constant:
	  printf("#");
	  recursively_dump_l (l->child);
	  break;	  
	case dlisp_quasiquote:
	  printf("`");
	  recursively_dump_l (l->child);
	  break;	  
	case dlisp_commaat:
	  printf(",@");
	  recursively_dump_l (l->child);
	  break;	  
	case dlisp_comma:
	  printf(",");
	  recursively_dump_l (l->child);
	  break;	  
	default:
	  printf ("\nFATAL ERROR UNKNOWN PARSED TEXT TYPE %i\n", l->type);
	  break;
	}
    }  
}


int
main()
{
  dlisp_lispentry * l = dlisp_read_lisp_text (stdin);

  {
    recursively_dump_l(l);
    printf ("\n");
  }
  
  return 0;
}
