/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "main.h"


gboolean
on_david_ventana_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		ventana = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
		switch (ret) {
			case 0: //Boton "si"
				gen_salir();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//creo que no es necesario
		//gtk_widget_destroy(ventana); 
		gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"delete_event");
	} else {
		gen_salir();
	}
	return TRUE;
}


void
on_new_file1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton=lookup_widget(david_ventana,"nuevo_boton");
	gtk_signal_emit_by_name(GTK_OBJECT(boton),"clicked");
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		widget = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(widget));
		switch (ret) {
			case 0: //Boton "si"
				gen_salir();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//Creo que no es necesario
		//gtk_widget_destroy(widget); 
	} else {
		gen_salir();
	}
}


void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_cortar_seleccion();
}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_copiar_seleccion();
}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_pegar_seleccion();
}


void
on_clear1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_borrar_seleccion();
}


void
on_nuevo1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana,*boton;
	
	ventana=create_proyecto_ventana();
	boton=get_widget(ventana,"ok_boton_proyecto");
	gtk_widget_set_sensitive(boton,FALSE);
	estado_proyecto_ventana=NUEVO;
	proyecto.xml_viejo=proyecto.xml;
	pro_crear();
	pro_mostrar(ventana);
	gtk_widget_show(ventana);
}


void
on_abrir1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	chdir(preferencias.directorio);
	ventana=create_archivos_ventana();
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
	estado_archivos_ventana=PROYECTO_ABRIR;
	gtk_widget_show(ventana);
}


void
on_propiedades1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml!=NULL) {	
		ventana=create_proyecto_ventana();
		estado_proyecto_ventana=PROPIEDADES;
		pro_mostrar(ventana);
		gtk_widget_show(ventana);
	}
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	ventana=create_preferencias_ventana();
	pref_mostrar(ventana);
	gtk_widget_show(ventana);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	ventana=create_acercade_ventana();
	gtk_widget_show(ventana);
}


void
on_ok_boton_seleccion_archivos_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget, *ventana;
	gchar *archivo;
	guint cont;
	int ret;
	
	widget=gtk_widget_get_toplevel(GTK_WIDGET(button));
	ventana_seleccion_proyecto=widget;
	archivo=gtk_file_selection_get_filename(GTK_FILE_SELECTION(widget));
	if (archivo[0]==0) {
		return;
	}
	for (cont=0;archivo[cont]!=0;cont++);
	if (archivo[cont-1]=='/') {
		return;
	}
	switch (estado_archivos_ventana) {
		case PROYECTO_ABRIR:
			if (edit_comprobar_perdida_datos()) {
				ventana = gen_create_perdidas_ventana();
				ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
				switch (ret) {
					case 0: //Boton "si"
						g_free(pro_proyecto_cargar);
						pro_proyecto_cargar=g_strdup(archivo);
						gen_abrir_proyecto(pro_proyecto_cargar);
						gen_cerrar_ventana(ventana_seleccion_proyecto);
						break;
					case 1: //Boton "no"
						break;
					default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
						break;
				}
				//Creo que no hace falta
				//gtk_widget_destroy(ventana); 
			} else {
				gen_abrir_proyecto(archivo);
				gen_cerrar_ventana(GTK_WIDGET(button));
			}
			break;
		case PROYECTO_ANADIR:
			gen_anadir(GTK_WIDGET(button));
			gen_cerrar_ventana(GTK_WIDGET(button));
			break;
	};
}


void
on_cancel_boton_seleccion_archivos_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_ok_boton_proyecto_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	switch (estado_proyecto_ventana) {
		case NUEVO:
			if (edit_comprobar_perdida_datos()) {
				ventana = gen_create_perdidas_ventana();
				ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
				switch (ret) {
					case 0: //Boton "si"
						ventana_propiedades_proyecto=GTK_WIDGET(button);
						gen_crear_proyecto(ventana_propiedades_proyecto);
						gen_cerrar_ventana(ventana_propiedades_proyecto);
						break;
					case 1: //Boton "no"
						break;
					default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
						break;
				}
				//Creo que no hace falta
				//gtk_widget_destroy(ventana); 
			} else {
				gen_crear_proyecto(GTK_WIDGET(button));
				gen_cerrar_ventana(GTK_WIDGET(button));
			}
			break;
		case PROPIEDADES:
			pro_actualizar(GTK_WIDGET(button));
			gen_cerrar_ventana(GTK_WIDGET(button));
			break;
	};
	edit_cambiar_reglas_coloreado();
	edit_aplicar_reglas_coloreado(edit_editor);
}


void
on_cancel_boton_proyecto_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	if (proyecto.xml_viejo!=NULL) {
		proyecto.xml=proyecto.xml_viejo;
		proyecto.xml_viejo=NULL;
	}
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_ok_boton_preferencias_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_actualizar(GTK_WIDGET(button));
	gen_cerrar_ventana(GTK_WIDGET(button));
	pref_aplicar();
}


void
on_cancel_boton_preferencias_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_anadir1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml!=NULL) {	
		ventana=create_archivos_ventana();
		gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
		estado_archivos_ventana=PROYECTO_ANADIR;
		gtk_widget_show(ventana);
	}
}


void
on_eliminar_del_proyecto1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_eliminar();
}


void
on_cefv_arbol_tree_select_row          (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
	struct s_lista_cefv *nodo,*hijos;
	struct s_lista_archivos *archivos;
	GtkCTree *arbol;
	GtkExText *editor;
	gchar *posicion;
	guint pos;
	gfloat ajuste;
	guint fila;
	guint cont;
	
	pos=1;
	ajuste=0;
	
	if ((node!=(GList *)cefv_clases) && (node!=(GList *)cefv_estructuras) &&
			(node!=(GList *)cefv_funciones) && (node!=(GList *)cefv_bariables) && (node!=(GList *)cefv_enumeraciones) &&
			(node!=(GList *)cefv_uniones) && (node!=(GList *)cefv_tipos)) {
				nodo=lista_cefv;
				if (nodo!=NULL) {
					while (nodo->nodo!=(GtkCTreeNode *)node) {
						if (nodo->hijos!=NULL) {
							hijos=nodo->hijos;
							while ((hijos!=NULL) && (hijos->nodo!=(GtkCTreeNode *)node)) {
								hijos=hijos->siguiente;
							}
							if (hijos==NULL) {
								nodo=nodo->siguiente;
							} else {
								nodo=hijos;
							}
						} else {
							nodo=nodo->siguiente;
						}
					}
					archivos=edit_conseguir_nodo(nodo->archivo);
					posicion=strstr(archivos->datos,nodo->definicion);
					if (posicion!=NULL) {
						pos=((guint)posicion)-((guint)(archivos->datos))+1;
						fila=1;
						for (cont=0;cont<pos;cont++) {
							if ((archivos->datos)[cont]==10) {
								fila++;
							}
						}
						if (fila>3) {
							fila-=2;
						} else {
							fila=1;
						}
						ajuste=(((gfloat)fila)/((gfloat)(archivos->filas)))*(archivos->limite_ajuste);
						archivos->posicion=pos-1;
						archivos->ajuste=ajuste;
					}
					if (archivos->pestana!=-1) {
						edit_actual=archivos;
						editor=edit_actual->editor;
						editor->vadj->value=ajuste;
						gtk_adjustment_value_changed(editor->vadj);
						gtk_editable_set_position(GTK_EDITABLE(editor),pos-1);
					}
					arbol=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
					gtk_ctree_select(arbol,archivos->nodo_arbol);
				}
	}
}


void
on_archivos_arbol_tree_select_row      (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	
	if ((node!=(GList *)arch_raiz) && (node!=(GList *)arch_cabeceras) &&
			(node!=(GList *)arch_fuentes) && (node!=(GList *)arch_otros)) {
				edit_ver((((((GtkCTreeRow *)(node->data))->row).cell)->u).text);
				widget=lookup_widget(david_ventana,"archivos_notebook");
				gtk_notebook_set_page(GTK_NOTEBOOK(widget),edit_actual->pestana);
	}
}

gboolean
on_archivos_arbol_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkMenu *menu;
	if ((event->button)==3) {
		menu=GTK_MENU(create_archivos_arbol_menu());
		gtk_menu_popup(menu,NULL,NULL,NULL,NULL,event->button,event->time);
	}
  return FALSE;
}


void
on_a_adir_archivo_existente1_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml!=NULL) {	
		ventana=create_archivos_ventana();
		gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
		estado_archivos_ventana=PROYECTO_ANADIR;
		gtk_widget_show(ventana);
	}
}


void
on_guardar_todo1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_guardar_todo();
}


void
on_nombre_entrada_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkEntry *ejecutable;
	gchar *texto;
	gchar *directorio;
	GtkWidget *ventana,*boton;

	ventana=gtk_widget_get_toplevel(GTK_WIDGET(editable));
	ejecutable=GTK_ENTRY(lookup_widget(ventana,"ejecutable_entrada"));
	texto=gtk_editable_get_chars(editable,0,-1);
	boton=get_widget(ventana,"ok_boton_proyecto");
	if (texto[0]!=0) {
		gtk_widget_set_sensitive(boton,TRUE);
	} else {
		gtk_widget_set_sensitive(boton,FALSE);
	}
	gtk_entry_set_text(ejecutable,texto);
	ejecutable=GTK_ENTRY(lookup_widget(ventana,"proyecto_entrada"));
	directorio=g_strdup_printf("%s%s",preferencias.directorio,texto);
	gtk_entry_set_text(ejecutable,directorio);
	g_free(directorio);
	ejecutable=GTK_ENTRY(lookup_widget(ventana,"glade_entrada"));
	directorio=g_strdup_printf("%s.glade",texto);
	gtk_entry_set_text(ejecutable,directorio);
	g_free(directorio);
	g_free(texto);
}


gboolean
on_editor_texto_enter_notify_event     (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
	gtk_widget_grab_focus(widget);
	return FALSE;
}


void
on_editor_texto_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		edit_actual->modificado=TRUE;
		edit_actual->analizado=FALSE;
	}
}

void
on_make_boton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	if (proyecto.archivo!=NULL) {
		//Los mensajes que aparezcan no seran parte de una busqueda
		if (texto_busqueda_actual != NULL) {
			g_free(texto_busqueda_actual);
			texto_busqueda_actual =  NULL;
		}
		widget=lookup_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		comp_run_make();
	}
}


gboolean
on_editor_texto_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkMenu *menu;
	if ((event->button)==3) {
		menu=GTK_MENU(create_editor_menu());
		gtk_menu_popup(menu,NULL,NULL,NULL,NULL,event->button,event->time);
		gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"button_press_event");
	}
	return FALSE;
}


void
on_cortar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_cortar_seleccion();
}


void
on_copiar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_copiar_seleccion();
}


void
on_pegar1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_pegar_seleccion();
}


void
on_borrar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_borrar_seleccion();
}


void
on_cancel_boton_buscar_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
	edit_mensaje("");
	buscar_buscando=FALSE;
}


void
on_buscar_boton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *buscar_ventana;
	GtkEntry *entrada;
	gchar *texto;
	
	//Comprobamos si se trata de una busqueda o un reemplazo
	buscar_ventana = gtk_widget_get_toplevel(GTK_WIDGET(button));
	entrada = GTK_ENTRY(lookup_widget(buscar_ventana,"reemplazar_entrada"));
	texto = gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	if (!strcmp(texto,"")) {       //Se trata de una busqueda
		buscar_busqueda(buscar_ventana);	
	} else {      //Se trata de una sustitucion
		buscar_siguiente(buscar_ventana);
		if (buscar_terminado) {
			edit_mensaje(_("No more maches."));
		}
	}
	g_free(texto);
}

void
on_buscar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_buscar2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_ok_boton_nuevo_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	DEBUG_MSG(on_ok_boton_nuevo_clicked pulsado);
	gen_nuevo(GTK_WIDGET(button));
}


void
on_reemplazar_boton_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_reemplazar(GTK_WIDGET(button));
}


void
on_reemplazar_todo_boton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_reemplazar_todo(GTK_WIDGET(button));
}


void
on_ayuda_gtk1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GTK);
}


void
on_ayuda_xml1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(XML);
}


void
on_compilar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	if (proyecto.archivo!=NULL) {
		widget=lookup_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		comp_compilar_actual();
	}
}


void
on_buscar_boton_barra_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_ayuda_glib1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GLIB);
}


void
on_nuevo2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton=lookup_widget(david_ventana,"nuevo_boton");
	gtk_signal_emit_by_name(GTK_OBJECT(boton),"clicked");
}


void
on_recargar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		ventana = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
		switch (ret) {
			case 0: //Boton "si"
				gen_recargar();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//Creo que no hace falta
		//gtk_widget_destroy(ventana); 
	} else {
		gen_recargar();
	}
}


gboolean
on_editor_texto_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	edit_actualizar_fila();
	switch (event->keyval) {
		case GDK_Left:
		case GDK_Right:
		case GDK_Up:
		case GDK_Down:

		case GDK_v:
		case GDK_V:
		case GDK_x:
		case GDK_X:
		case GDK_c:
		case GDK_C:
			
		case GDK_Tab:
			return TRUE;
		break;
	}
	return FALSE;
}

gboolean
on_editor_texto_button_press_event_despues
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	edit_actualizar_fila();
	return FALSE;
}


void
on_editor_texto_insert_text            (GtkEditable     *editable,
                                        gchar           *new_text,
                                        gint             new_text_length,
                                        gint            *position,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		edit_auto_formato(editable,new_text,new_text_length,position);
	}
}


void
on_abrir_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	chdir(preferencias.directorio);
	ventana=create_archivos_ventana();
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
	estado_archivos_ventana=PROYECTO_ABRIR;
	gtk_widget_show(ventana);
}


void
on_guardar_todo_boton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	edit_guardar_todo();
}


gboolean
on_buscar_ventana_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	edit_mensaje("");
	buscar_buscando=FALSE;
	return FALSE;
}


void
on_super_indentacion_boton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	if (gtk_toggle_button_get_active(togglebutton)) {
		boton=GTK_TOGGLE_BUTTON(lookup_widget(ventana,"auto_indentacion_boton"));
		gtk_toggle_button_set_active(boton,TRUE);
	} else {
		boton=GTK_TOGGLE_BUTTON(lookup_widget(ventana,"cerrar_llaves_boton"));
		gtk_toggle_button_set_active(boton,FALSE);
	}
}


void
on_cerrar_llaves_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	boton=GTK_TOGGLE_BUTTON(lookup_widget(ventana,"super_indentacion_boton"));
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_toggle_button_set_active(boton,TRUE);
	}
}


void
on_auto_indentacion_boton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	if (!gtk_toggle_button_get_active(togglebutton)) {
		boton=GTK_TOGGLE_BUTTON(lookup_widget(ventana,"super_indentacion_boton"));
		gtk_toggle_button_set_active(boton,FALSE);
	}
}


void
on_a_adir_tabulacion1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_anadir_tabulacion();
}


void
on_eliminar_tabulacion1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_eliminar_tabulacion();
}


void
on_cancel_boton_nuevo_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_eliminar_del_disco1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (edit_actual!=NULL) {
		ventana=create_borrar_archivo_ventana();
		gtk_widget_show(ventana);
	}
}


void
on_ok_boton_borrar_archivo_ventana_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *archivo;
	
	archivo=pro_nombre_completo_archivo(edit_actual->nombre,FALSE);
	gen_eliminar();
	remove(archivo);
	g_free(archivo);
}


void
on_editor_texto_delete_text            (GtkEditable     *editable,
                                        gint             start_pos,
                                        gint             end_pos,
                                        gpointer         user_data)
{
/*	if (edit_actual!=NULL) {
		edit_ver(edit_actual->nombre);
	} */
}


void
on_glade_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gla_ejecutar();
}

gboolean
on_mensajes_texto_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	guint posicion;
	gchar *mensajes;
	guint cont,cont1,cont2,cont3;
	guint size;
	gchar *archivo, *archivo_tmp, *seleccion;
	gchar *fila_c;
	guint fila;
	struct s_lista_archivos *archivos;
	GtkCTree *arbol;
	//extern texto_busqueda_actual;
	
	if (event->button==1) {
		posicion=gtk_editable_get_position(GTK_EDITABLE(widget));
		mensajes=gtk_editable_get_chars(GTK_EDITABLE(widget),0,-1);
		//size=GTK_EXTEXT(widget)->length; 
		size=gtk_text_get_length(GTK_TEXT(widget));
		//nos situamos la principio de la linea
		for (cont1=posicion;(mensajes[cont1]!='\n') && (cont1>0);cont1--);
		if (cont1!=0) {
			cont1++;
		}
		//si es una linea de error, deberia tener el formato fichero:linea:error, asi que lo buscamos
		//y deshechamos la lineas si no lo tiene
		for (cont2=cont1;(mensajes[cont2]!=':') && (mensajes[cont2]!='\n') && (cont2<size);cont2++);
		//Si hemos llegado a un '\n', eso quiere decir que no era un mensaje de error, asi que nos salimos
		//idem si hemos llegado al final del texto
		if ((cont2<size) && (mensajes[cont2]!='\n')) {
			cont3=cont2+1;
			for (;(mensajes[cont3]!=':') && (mensajes[cont3]!='\n') && (cont3<size);cont3++);
			//Solo nos interesa el caso en que SI haya encontrado los ":"
			if (mensajes[cont3]!=':'){
				g_free(mensajes);
				return FALSE;
			}
		} else {
			g_free(mensajes);
			return FALSE;
			//cont3=cont2;
		}
		archivo=g_strndup(mensajes+cont1,cont2-cont1);
		//Lo siguiente es solo para mensajes de Make
		//Le quitamos el tabulador que tiene delante al nombre de archivo
		if (texto_busqueda_actual == NULL) {
			if (archivo[0]=='\t') {
				archivo_tmp = g_strdup (archivo);
				g_free(archivo);
				archivo = g_strdup (archivo_tmp+1);
				g_free (archivo_tmp);
			}
		}
		//Si el nombre de archivo tiene una ruta completa, nos quedamos solo con el nombre
		if (archivo[0] == '/') {
			for (cont=0;(archivo[cont]!='\0');cont++);
			for (;archivo[cont]!='/';cont--);
			cont++;
			archivo_tmp = g_strdup (archivo);
			g_free(archivo);
			archivo = g_strdup (archivo_tmp+cont);
			g_free(archivo_tmp);
		}
		//si el nombre no tenia path completo cont = 0, si tenia path completo cont sera el numero de
		//posiciones a avanzar hasta llegar al nombre de archivo.
		if (pro_existe_archivo(archivo)) {
			fila_c=g_strndup(mensajes+cont2+1,cont3-cont2-1);
			fila=atoi(fila_c);
			if (fila) {
				archivos=raiz_lista_archivos;
				while (strcmp(archivos->nombre,archivo)) {
					archivos=archivos->siguiente;
				}
				arbol=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
				gtk_ctree_select(arbol,archivos->nodo_arbol);
				posicion = edit_ir_a_fila(fila,edit_actual->filas);
				//En caso de estar en una busqueda, resaltamos la cadena buscada
				if (texto_busqueda_actual != NULL) {
					if (estado_botones.sensitive) {
						seleccion=strstr(&((edit_actual->datos)[posicion]),texto_busqueda_actual);
					} else {
						seleccion=strcasestr(&((edit_actual->datos)[posicion]),texto_busqueda_actual);
					}
					if (seleccion!=NULL) {
						//calculamos la posicion de la palabra en el texto
						posicion = ((guint)seleccion)-((guint)(edit_actual->datos));
						edit_ir_a_posicion(posicion,edit_actual->filas);
						gtk_editable_set_position(GTK_EDITABLE(edit_actual->editor),posicion);
						edit_actualizar_fila();
						((GTK_EDITABLE(edit_actual->editor))->has_selection)=0;
						gtk_editable_select_region(GTK_EDITABLE(edit_actual->editor),posicion,posicion+strlen(texto_busqueda_actual));
					} //fin de (seleccion != NULL)
				} //fin de (texto_busqueda_actual != NULL)
			}
		}
		g_free(archivo);
		g_free(mensajes);
	}
	return FALSE;
}


void
on_ayuda_orbit1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(ORBIT);
}


void
on_glade_proyecto_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	widget=lookup_widget(ventana,"glade_fileentry");
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_widget_set_sensitive(widget,TRUE);
	} else {
		gtk_widget_set_sensitive(widget,FALSE);
	}
}

void
on_imprimir_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *archivo;
	gchar *comando;
	
	if (edit_actual!=NULL) {
		edit_guardar();
		archivo=pro_nombre_completo_archivo(edit_actual->nombre,FALSE);
		comando=g_strdup_printf("lpr %s\n",archivo);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(archivo);
	}
}


GtkWidget*
editor_texto_new (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
	GtkWidget *editor_texto;

	editor_texto=gtk_extext_highlight_new();
	gtk_extext_set_adjustments(GTK_EXTEXT(editor_texto),NULL ,NULL);
	edit_estilo=gtk_style_copy(gtk_widget_get_style(editor_texto));
	gtk_style_ref(edit_estilo);
	edit_estilo->bg[GTK_STATE_PRELIGHT]=c_prelight;
	gtk_widget_set_style(editor_texto,edit_estilo);
	gtk_extext_style_set(editor_texto,NULL);
	GTK_EXTEXT(editor_texto)->draw_pixbufs=FALSE;
	GTK_EXTEXT(editor_texto)->pixbuf_max_width=0;
	GTK_EXTEXT(editor_texto)->select_line=FALSE;
	gtk_extext_undo_set_max(GTK_EXTEXT(editor_texto),100);
	
	return editor_texto;
}


void
on_defecto_boton_preferencias_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fuente;
	GtkWidget *widget;

	c_fondo.red=65535;
	c_fondo.green=65535;
	c_fondo.blue=65535;

	c_nada.red=0;
	c_nada.green=0;
	c_nada.blue=0;

	c_comentario.red=40000;
	c_comentario.green=40000;
	c_comentario.blue=40000;

	c_directiva.red=1000;
	c_directiva.green=45000;
	c_directiva.blue=1000;

	c_cadena_cs.red=65535;
	c_cadena_cs.green=40000;
	c_cadena_cs.blue=0;

	c_cadena_cd.red=65535;
	c_cadena_cd.green=20000;
	c_cadena_cd.blue=0;

	c_etiqueta.red=1000;
	c_etiqueta.green=1000;
	c_etiqueta.blue=50000;

	c_entero.red=50000;
	c_entero.green=1000;
	c_entero.blue=1000;

	c_real.red=40000;
	c_real.green=50000;
	c_real.blue=0;

	c_hexadecimal.red=60000;
	c_hexadecimal.green=0;
	c_hexadecimal.blue=60000;

	c_octal.red=50000;
	c_octal.green=40000;
	c_octal.blue=30000;

	widget=gtk_widget_get_toplevel(GTK_WIDGET(button));
	
	fuente=lookup_widget(widget,"texto_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_nada.red,c_nada.green,c_nada.blue,0);
	fuente=lookup_widget(widget,"defines_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_directiva.red,c_directiva.green,c_directiva.blue,0);
	fuente=lookup_widget(widget,"reservadas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_etiqueta.red,c_etiqueta.green,c_etiqueta.blue,0);
	fuente=lookup_widget(widget,"comentarios_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_comentario.red,c_comentario.green,c_comentario.blue,0);
	fuente=lookup_widget(widget,"cadenas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cd.red,c_cadena_cd.green,c_cadena_cd.blue,0);
	fuente=lookup_widget(widget,"caracteres_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cs.red,c_cadena_cs.green,c_cadena_cs.blue,0);
	fuente=lookup_widget(widget,"naturales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_entero.red,c_entero.green,c_entero.blue,0);
	fuente=lookup_widget(widget,"reales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_real.red,c_real.green,c_real.blue,0);
	fuente=lookup_widget(widget,"hexadecimales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_hexadecimal.red,c_hexadecimal.green,c_hexadecimal.blue,0);
	fuente=lookup_widget(widget,"octales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_octal.red,c_octal.green,c_octal.blue,0);
	fuente=lookup_widget(widget,"fondo_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_fondo.red,c_fondo.green,c_fondo.blue,0);
}


void
on_x11_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LX11]=='0') {
			xmlSetProp(nodo,"gnomeui","0");
			xmlSetProp(nodo,"gtk","0");
			xmlSetProp(nodo,"imlib","0");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_gtk_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGTK]=='0') {
			xmlSetProp(nodo,"gnomeui","0");
		} else {
			xmlSetProp(nodo,"x11","1");
			xmlSetProp(nodo,"glib","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_xml_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_gnome_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGNOME]=='0') {
			xmlSetProp(nodo,"gnomeui","0");
		} else {
			xmlSetProp(nodo,"glib","1");
			xmlSetProp(nodo,"audiofile","1");
			xmlSetProp(nodo,"esd","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_orbit_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LORBIT]=='0') {
			xmlSetProp(nodo,"gnorba","0");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_glib_libs_boton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGLIB]=='0') {
			xmlSetProp(nodo,"gnome","0");
			xmlSetProp(nodo,"gnomeui","0");
			xmlSetProp(nodo,"gnorba","0");
			xmlSetProp(nodo,"gtk","0");
			xmlSetProp(nodo,"gmodule","0");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_gettext_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_gnomeui_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGNOMEUI]=='1') {
			xmlSetProp(nodo,"glib","1");
			xmlSetProp(nodo,"gmodule","1");
			xmlSetProp(nodo,"gtk","1");
			xmlSetProp(nodo,"gnome","1");
			xmlSetProp(nodo,"x11","1");
			xmlSetProp(nodo,"esd","1");
			xmlSetProp(nodo,"audiofile","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_gnorba_libs_boton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGNORBA]=='1') {
			xmlSetProp(nodo,"glib","1");
			xmlSetProp(nodo,"orbit","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_funciones_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	gchar *funcion;
	struct s_lista_cefv *nodo;
	struct s_lista_archivos *archivos;
	gboolean encontrado;
	gint cont;
	gchar *posicion;
	guint pos=0;
	guint fila;
	gfloat ajuste=0;
	GtkCTree *arbol;
	GtkNotebook *notebook;
	
	if (cefv_congelar_lista_combo) return;
	funcion=gtk_editable_get_chars(editable,0,-1);
	if ((funcion==NULL) || (funcion[0]==0)) {
		g_free(funcion);
		return;
	}
	nodo=lista_cefv;
	encontrado=FALSE;
	while ((nodo!=NULL) && (!encontrado)) {
		if (!strcmp(nodo->rama,funcion)) {
			encontrado=TRUE;
		} else {
			nodo=nodo->siguiente;
		}
	}
	if (nodo==NULL) {
		g_free(funcion);
		return;
	}
	archivos=raiz_lista_archivos;
	while (strcmp(archivos->nombre,nodo->archivo)) {
		archivos=archivos->siguiente;
	}
	posicion=strstr(archivos->datos,nodo->definicion);
	if (posicion!=NULL) {
		pos=((guint)posicion)-((guint)(archivos->datos))+1;
		fila=1;
		for (cont=0;cont<pos;cont++) {
			if ((archivos->datos)[cont]==10) {
				fila++;
			}
		}
		if (fila>3) {
			fila-=2;
		} else {
			fila=1;
		}
		ajuste=(((gfloat)fila)/((gfloat)(archivos->filas)))*(archivos->limite_ajuste);
		archivos->posicion=pos-1;
		archivos->ajuste=ajuste;
	}
	if (archivos->pestana==-1) {
		arbol=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
		gtk_ctree_select(arbol,archivos->nodo_arbol);
	} else {
		archivos->editor->vadj->value=ajuste;
		gtk_adjustment_value_changed(archivos->editor->vadj);
		gtk_editable_set_position(GTK_EDITABLE(archivos->editor),pos-1);
		notebook=GTK_NOTEBOOK(lookup_widget(david_ventana,"archivos_notebook"));
		gtk_notebook_set_page(notebook,archivos->pestana);
	}
	g_free(funcion);
}


void
on_arboles_togglebutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	static gint posicion;
	
	widget=lookup_widget(david_ventana,"arboles_notebook");
	if (gtk_toggle_button_get_active(togglebutton))
	{
		gtk_widget_show(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = lookup_widget(david_ventana,"show_file_box1");
		gtk_signal_handler_block_by_func(GTK_OBJECT(widget),on_show_file_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),TRUE);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(widget),on_show_file_box1_activate,NULL);

		widget=lookup_widget(david_ventana,"arboles_hpaned");
		gtk_paned_set_handle_size(GTK_PANED(widget),10);
		gtk_paned_set_gutter_size(GTK_PANED(widget),10);
		GTK_PANED(widget)->child1_size=posicion;
	} else {
		gtk_widget_hide(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = lookup_widget(david_ventana,"show_file_box1");
		gtk_signal_handler_block_by_func(GTK_OBJECT(widget),on_show_file_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),FALSE);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(widget),on_show_file_box1_activate,NULL);

		widget=lookup_widget(david_ventana,"arboles_hpaned");
		posicion=GTK_PANED(widget)->child1_size;
		GTK_PANED(widget)->child1_size=GTK_PANED(widget)->min_position;
		gtk_paned_set_handle_size(GTK_PANED(widget),0);
		gtk_paned_set_gutter_size(GTK_PANED(widget),0);
	}
}


void
on_mensajes_togglebutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	static gint posicion;
	
	widget=lookup_widget(david_ventana,"mensajes_scrolledwindow");
	if (gtk_toggle_button_get_active(togglebutton))
	{
		gtk_widget_show(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = lookup_widget(david_ventana,"show_message_box1");
		gtk_signal_handler_block_by_func(GTK_OBJECT(widget),on_show_message_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),TRUE);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(widget),on_show_message_box1_activate,NULL);

		widget=lookup_widget(david_ventana,"mensajes_vpaned");
		gtk_paned_set_handle_size(GTK_PANED(widget),10);
		gtk_paned_set_gutter_size(GTK_PANED(widget),10);
		GTK_PANED(widget)->child1_size=posicion;
	} else {
		gtk_widget_hide(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = lookup_widget(david_ventana,"show_message_box1");
		gtk_signal_handler_block_by_func(GTK_OBJECT(widget),on_show_message_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),FALSE);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(widget),on_show_message_box1_activate,NULL);

		widget=lookup_widget(david_ventana,"mensajes_vpaned");
		posicion=GTK_PANED(widget)->child1_size;
		GTK_PANED(widget)->child1_size=GTK_PANED(widget)->max_position;
		gtk_paned_set_handle_size(GTK_PANED(widget),0);
		gtk_paned_set_gutter_size(GTK_PANED(widget),0);
	}
}


void
on_ddd_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *ejecutable;
	pid_t pid;
	gchar *argumentos[3];
	
	if (proyecto.xml==NULL) return;
	if ((pid=fork())==0) {
		ejecutable=pro_nombre_completo_archivo("ejecutable.c",TRUE);
		g_free(ejecutable);
		ejecutable=pro_ejecutable();
		
		argumentos[0]=g_strdup("ddd");
		argumentos[1]=ejecutable;
		argumentos[2]=NULL;
		execvp("ddd",argumentos);
	}
}


void
on_audiofile_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LAUDIOFILE]=='0') {
			xmlSetProp(nodo,"esd","0");
			xmlSetProp(nodo,"gnome","0");
			xmlSetProp(nodo,"gnomeui","0");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_gmodule_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LGMODULE]=='0') {
			xmlSetProp(nodo,"gnomeui","0");
		} else {
			xmlSetProp(nodo,"glib","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_esd_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LESD]=='0') {
			xmlSetProp(nodo,"gnomeui","0");
			xmlSetProp(nodo,"gnome","0");
		} else {
			xmlSetProp(nodo,"audiofile","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_imlib_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gchar *libs;
	xmlNodePtr nodo;
	
	if (!pro_forzando_librerias) {
		pro_forzando_librerias=TRUE;
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		libs=pro_librerias_lincado();
		if (libs[LIMLIB]=='0') {
		} else {
			xmlSetProp(nodo,"x11","1");
		}
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
		g_free(libs);
		pro_forzando_librerias=FALSE;
	}
}


void
on_ayuda_gnome1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNOME);
}


void
on_ayuda_gnomeui1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNOMEUI);
}


void
on_ayuda_gnorba1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNORBA);
}


void
on_archivos_notebook_switch_page       (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	GtkWidget *entrada;
	gchar *funcion;
	
	if (proyecto.xml==NULL) return;
	if (page_num==1) {
		entrada=lookup_widget(david_ventana,"historico_funciones_entry");
		funcion=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
		edit_ver_funcion(funcion,FALSE);
		g_free(funcion);
		return;
	}
	edit_actual=raiz_lista_archivos;
	while (edit_actual!=NULL && edit_actual->pestana!=page_num) {
		edit_actual=edit_actual->siguiente;
	}
	edit_actualizar_fila();
}


void
on_historico_funciones_entry_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	gchar *funcion;
	
	if (edit_congelar_historico) return;
	funcion=gtk_editable_get_chars(editable,0,-1);
	edit_ver_funcion(funcion, FALSE);
	g_free(funcion);
}


void
on_project1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"abrir_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");

}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_guardar();
}


void
on_imprimir1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"imprimir_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");

}


void
on_compile1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"compilar_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_make1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"make_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_glade1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gla_ejecutar();
}


void
on_ddd1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"ddd_button");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_show_message_box1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	if (david_ventana != NULL) {
		boton = lookup_widget (david_ventana, "mensajes_togglebutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton))) 
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton), FALSE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
	}
}


void
on_show_file_box1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	if (david_ventana != NULL) {
		boton = lookup_widget (david_ventana, "arboles_togglebutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton))) 
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton), FALSE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
	}

}


void
on_mover_a_pestana_nueva1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkNotebook *notebook;
	GtkWidget *etiqueta;
	GtkWidget *editor_texto;
	GtkWidget *scrolledwindow;
	GtkStyle *estilo;
	gboolean modificado;
	
	DEBUG_MSG(->on_mover_a_pestana_nueva1_activate);
	if (edit_actual==NULL || edit_actual->pestana!=0) {
		DEBUG_MSG(<-on_mover_a_pestana_nueva1_activate 1);
		return;
	}
	edit_total_pestanas++;
	notebook=GTK_NOTEBOOK(lookup_widget(david_ventana,"archivos_notebook"));
	etiqueta=gtk_label_new(edit_actual->nombre);
	editor_texto=editor_texto_new(NULL,NULL,NULL,0,0);
	gtk_signal_connect (GTK_OBJECT (editor_texto), "enter_notify_event",GTK_SIGNAL_FUNC (on_editor_texto_enter_notify_event),NULL);
	gtk_signal_connect_after (GTK_OBJECT (editor_texto), "changed",GTK_SIGNAL_FUNC (on_editor_texto_changed),NULL);
	gtk_signal_connect (GTK_OBJECT (editor_texto), "button_press_event",GTK_SIGNAL_FUNC (on_editor_texto_button_press_event),NULL);
	gtk_signal_connect_after (GTK_OBJECT (editor_texto), "key_press_event",GTK_SIGNAL_FUNC (on_editor_texto_key_press_event),NULL);
	gtk_signal_connect_after (GTK_OBJECT (editor_texto), "button_press_event",GTK_SIGNAL_FUNC (on_editor_texto_button_press_event_despues),NULL);
	gtk_signal_connect_after (GTK_OBJECT (editor_texto), "insert_text",GTK_SIGNAL_FUNC (on_editor_texto_insert_text),NULL);
	gtk_signal_connect_after (GTK_OBJECT (editor_texto), "delete_text",GTK_SIGNAL_FUNC (on_editor_texto_delete_text),NULL);
	scrolledwindow=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow),editor_texto);
	GTK_EXTEXT(editor_texto)->vadj=GTK_VSCROLLBAR(GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar)->scrollbar.range.adjustment;
	GTK_EXTEXT(editor_texto)->hadj=GTK_HSCROLLBAR(GTK_SCROLLED_WINDOW(scrolledwindow)->hscrollbar)->scrollbar.range.adjustment;
	edit_aplicar_reglas_coloreado(GTK_EXTEXT(editor_texto));
	estilo=gtk_style_copy(gtk_widget_get_style(editor_texto));
	gtk_style_ref(estilo);
	estilo->bg[GTK_STATE_NORMAL]=c_fondo;
	estilo->text[GTK_STATE_NORMAL]=c_nada;
	gtk_widget_set_style(editor_texto,estilo);
	gtk_extext_set_tab_width(GTK_EXTEXT(editor_texto),preferencias.tabulador);
	gtk_widget_show(editor_texto);
	gtk_widget_show(scrolledwindow);
	gtk_notebook_append_page(notebook,scrolledwindow,etiqueta);

	edit_actualizar();

	edit_actual->editor=GTK_EXTEXT(editor_texto);
	edit_actual->pestana=-1;
	edit_ver(edit_actual->nombre);
	edit_actual->pestana=edit_total_pestanas;
	gtk_notebook_set_page(notebook,edit_total_pestanas);
	modificado=edit_actual->modificado;
	gtk_editable_delete_text(GTK_EDITABLE(edit_editor),0,gtk_extext_get_length(edit_editor));
	gtk_editable_set_editable(GTK_EDITABLE(edit_editor),FALSE);
	edit_actual->modificado=modificado;
	etiqueta=lookup_widget(david_ventana,"editor_etiqueta");
	gtk_label_set(GTK_LABEL(etiqueta),_("Files"));
	DEBUG_MSG(<-on_mover_a_pestana_nueva1_activate);
}


void
on_eliminar_esta_pestana1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gint pestana_actual;
	GtkWidget *notebook;
	
	DEBUG_MSG(->on_eliminar_esta_pestana1_activate);
	if (edit_actual!=NULL && edit_actual->pestana>1) {
		pestana_actual=edit_actual->pestana;
		notebook=lookup_widget(david_ventana,"archivos_notebook");
		if (edit_actual->modificado) {
			edit_actualizar();
			if (!edit_actual->analizado) {
				cefv_analizar_archivo(edit_actual->nombre);
				edit_actual->analizado=TRUE;
			}
		}
		edit_actual->editor=NULL;
		edit_actual->pestana=-1;
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),pestana_actual);
		edit_total_pestanas--;
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL) {
			if (edit_actual->pestana>pestana_actual) {
				edit_actual->pestana--;
			}
			edit_actual=edit_actual->siguiente;
		}
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
	}
	DEBUG_MSG(<-on_eliminar_esta_pestana1_activate);
}


void
on_boton_buscar_current_file_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana_busqueda, *widget;
	
	//Escondemos o mostramos las opciones de la ventana de busqueda
	//segun corresponda
	ventana_busqueda = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	widget = lookup_widget(ventana_busqueda, "caja_opciones_current");
	if (gtk_toggle_button_get_active(togglebutton))
		gtk_widget_set_sensitive (widget, TRUE);
	else
		gtk_widget_set_sensitive (widget, FALSE);
}


void
on_boton_buscar_multiple_files_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana_busqueda, *widget;
	
	//Escondemos o mostramos las opciones de la ventana de busqueda
	//segun corresponda
	ventana_busqueda = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	widget = lookup_widget(ventana_busqueda, "caja_opciones_multiple");
	if (gtk_toggle_button_get_active(togglebutton))
		gtk_widget_set_sensitive (widget, TRUE);
	else
		gtk_widget_set_sensitive (widget, FALSE);

}


void
on_mostrar_funcion1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gint tipo;
	gint inicio,fin;
	gint pos;
	gchar *datos;
	gchar *funcion;
	gint cont;
	
	DEBUG_MSG(->on_mostrar_funcion1_activate);
	if (edit_actual==NULL) return;
	if (lista_cefv==NULL) return;
	//mostramos funciones solo si el archivo actual es un archivo de fuentes o de cabeceras
	tipo=gen_tipo_archivo(edit_actual->nombre);
	if ((tipo==1) || (tipo==2)) {
		edit_actualizar();
		pos=edit_actual->posicion;
		datos=edit_actual->datos;
		// con estos dos for localizamos el nombre completo de la funcion en el archivo
		for (inicio=pos;((datos[inicio]>='a') && (datos[inicio]<='z')) || ((datos[inicio]>='A') && (datos[inicio]<='Z')) || (datos[inicio]=='_') || ((datos[inicio]>='0') && (datos[inicio]<='9'));inicio--);
		inicio++;
		for (fin=pos;((datos[fin]>='a') && (datos[fin]<='z')) || ((datos[fin]>='A') && (datos[fin]<='Z')) || (datos[fin]=='_') || ((datos[fin]>='0') && (datos[fin]<='9'));fin++);
		fin--;
		//El cursor debia estar en una funcion, luego inicio debe ser < que fin siempre
		//si es >= significa que el cursor no estaba sobre una funcion asi que nos salimos
		if (inicio < fin) {
			// hacemos una copia del nombre de la funcion para mostrarla
			funcion=g_malloc(fin-inicio+2);
			for (pos=inicio,cont=0;pos<=fin;pos++,cont++) {
				funcion[cont]=datos[pos];
			}
			funcion[cont]=0;
			edit_ver_funcion(funcion, TRUE);
			g_free(funcion);
		} 
	}
	DEBUG_MSG(<-on_mostrar_funcion1_activate);
}


void
on_nuevo_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml==NULL) return;
	ventana=create_nuevo_ventana();
	gtk_widget_show(ventana);
}


void
on_memprof2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"memprof_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_guardar_boton_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	edit_guardar();
}


void
on_memprof_boton_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *ejecutable,*tmp;
	pid_t pid;
	gchar *argumentos[3];
	
	if (proyecto.xml==NULL) return;
	if ((pid=fork())==0) {
		tmp=pro_nombre_completo_archivo("ejecutable.c",TRUE);
		g_free(tmp);
		tmp=pro_ejecutable();
		ejecutable=g_strdup_printf("./%s",tmp);
		g_free(tmp);
		
		argumentos[0]=g_strdup("memprof");
		argumentos[1]=ejecutable;
		argumentos[2]=NULL;
		execvp("memprof",argumentos);
	}
}


void
on_run1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = lookup_widget (david_ventana,"ejecutar_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_ejecutar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *prodir,*srcdir,*ejecutable,*nombre;
	pid_t pid;
	gchar *argumentos[4];
	
	if (proyecto.xml==NULL) return;
	if (comp_run_make()) return;
	if ((pid=fork())==0) {
		prodir=pro_prodir();
		srcdir=pro_srcdir();
		ejecutable=pro_ejecutable();
		nombre=pro_nombre();
		argumentos[0]=g_strdup("gnome-terminal");
		argumentos[1]=g_strdup_printf("-e %s/%s/%s",prodir,srcdir,ejecutable);
		argumentos[2]=g_strdup_printf("-t %s",nombre);
		argumentos[3]=NULL;
		execvp("gnome-terminal",argumentos);
		g_free(prodir);
		g_free(srcdir);
		g_free(ejecutable);
		g_free(nombre);
	}
}


void
on_deshacer2_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ((edit_actual->pestana!=-1) && (edit_actual->pestana!=1)) {
		if (!gtk_extext_undo_is_empty(edit_actual->editor)) {
			gtk_extext_undo(edit_actual->editor);
		}
	}
}


void
on_rehacer1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ((edit_actual->pestana!=-1) && (edit_actual->pestana!=1)) {
		if (!gtk_extext_redo_is_empty(edit_actual->editor)) {
			gtk_extext_redo(edit_actual->editor);
		}
	}
}


void
on_clean1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *comando, *temp;
	
	if (proyecto.xml != NULL) {
#ifdef _NETBSD
		comando=g_strdup("gmake clean 1>/dev/null 2>/dev/stdout");
#endif
#ifdef _FREEBSD
		comando=g_strdup("gmake clean 1>/dev/null 2>/dev/stdout");
#endif
#ifdef _LINUX
		comando = g_strdup("make clean 1>/dev/null 2>/dev/stdout");
#endif
		//nos situamos en el directorio raiz del proyecto
		temp = pro_nombre_completo_archivo(proyecto.archivo, TRUE);
		gen_comando (comando,"---------------------------- Cleaning project ----------------------------\n");
		g_print("Done.\n");
		g_free(comando);
		g_free(temp);
	}
}

