/* directory.h							-*- C++ -*-
     $Id: directory.h,v 1.11 2001/11/27 23:57:36 elf Exp $

   written by Marc Singer
   20 September 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Header for directory class.


*/

#if !defined (_DIRECTORY_H_)
#    define   _DIRECTORY_H_

#include <dirent.h>

typedef bool (*PFN_DIRECTORY_SELECT)  (const char* szFile, void* pv);
typedef int (*PFN_DIRECTORY_COMPARE) (const void* pv0, const void* pv1);

typedef enum {
  fileRankDirectory = 1,
  fileRankFile	    = 2,
  fileRankOther	    = 3,
} eFileRank;

typedef struct {
  char* szPath;			// Pointer to file/directory name
  off_t cb;			/* Length of file in bytes */
  umode_t mode;			/* Mode/type of file */
  time_t time;			/* Time of last change to file */
  void* pvUser;			// Caller's baggage
} FILE_INFO;

class LDirectory {
protected:
  char* m_szPath;		/* Original path */

  		// -- Enumerated files 
  FILE_INFO* m_rgInfo;
  int m_cFiles;
  int m_cFilesMax;

  bool _is_ok (int iFile) {
    return m_rgInfo && iFile >= 0 && iFile < m_cFiles; }
  void _stat (int iFile);


public:
  LDirectory () {
    zero (); }
  LDirectory (const char* szPath) {
    zero (); init (szPath); }
  ~LDirectory () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (const char* szPath);
  void release_this (void);
  void release_files (void);

  int alloc_to (int cFiles);
  int count_files (void) {
    return m_cFiles; }
  const char* path (void) {
    return m_szPath; }

  bool is_directory (int iFile);
  static bool is_directory (FILE_INFO* pInfo);
  bool is_file (int iFile);
  static bool is_file (FILE_INFO* pInfo);
  bool is_softlink (int iFile);

  const char* abbreviate (int cchMax);
  int add_file (const char* szFile, int cch);
  int enumerate (PFN_DIRECTORY_SELECT pfn, void* pv);
  static const char* file (FILE_INFO* pInfo) {
    return pInfo->szPath; }
  const char* file (int iFile) {
    return _is_ok (iFile) ? m_rgInfo[iFile].szPath : (const char*) NULL; }
  FILE_INFO* file_info (int iFile) {
    return _is_ok (iFile) ? &m_rgInfo[iFile] : (FILE_INFO*) 0; }
  bool exists (void);
  int find (const char* szFile, int cch);
  void normalize (void);
  static int rank (FILE_INFO* pInfo);
  void sort (PFN_DIRECTORY_COMPARE pfn);
  static int sort_alpha_compare (const void*, const void*);
  static long size (FILE_INFO* pInfo) {
    return pInfo->cb; }
  long size (int iFile) {
    return _is_ok (iFile) ? m_rgInfo[iFile].cb : 0; }
  void set_user (int iFile, void* pvUser) {
    if (_is_ok (iFile))
      m_rgInfo[iFile].pvUser = pvUser; }
  void stat (int iFile) {
    if (!_is_ok (iFile))
      return;
    _stat (iFile); }
  static time_t time (FILE_INFO* pInfo) {
    return pInfo->time; }
  time_t time (int iFile) {
    return _is_ok (iFile) ? m_rgInfo[iFile].time : 0; }
  static void* user (FILE_INFO* pInfo) {
    return pInfo->pvUser; }
  void* user (int iFile) {
    return _is_ok (iFile) ? m_rgInfo[iFile].pvUser : 0; }
};

#endif /* _DIRECTORY_H_ */
